/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.ComponentDao;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.PrivacyGatewayMapping;
import com.pg.factory.BlukryptMongoFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class ComponentDaoImpl
implements ComponentDao {
    private BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private static Logger logger = LoggerFactory.getLogger(ComponentDaoImpl.class);

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public Components getComponents(String gatewayName, int cloudId) {
        Criteria criteria = Criteria.where((String)"gatewayName").is((Object)gatewayName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        PrivacyGateway privacyGateway = (PrivacyGateway)mongoTemplate.findOne(query, PrivacyGateway.class);
        Components components = new Components();
        if (!StringUtils.isEmpty((Object)privacyGateway)) {
            components.setComponentName(gatewayName);
            components.setComponentsProperties(privacyGateway.getComponentsProperties());
            components.setNoOfThreadsUsed(privacyGateway.getNoOfThreadsUsed());
        }
        return components;
    }

    @Override
    public void updateComponentProperties(String gatewayName, int cloudId, long noOfThreadsUsed) {
        Criteria criteria = Criteria.where((String)"gatewayName").is((Object)gatewayName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("noOfThreadsUsed", (Object)noOfThreadsUsed);
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, PrivacyGateway.class);
        logger.debug(".......updateFirst......" + updateFirst);
        logger.debug(".......updateFirst......" + updateFirst.getMatchedCount() + "........." + updateFirst.getModifiedCount());
    }

    @Override
    @Cacheable(value={"getPrivacyGatewayMapping"})
    public PrivacyGatewayMapping getPrivacyGatewayMapping(int cloudId, String gatewayName) {
        Criteria criteria = Criteria.where((String)"gatewayName").is((Object)gatewayName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (PrivacyGatewayMapping)mongoTemplate.findOne(query, PrivacyGatewayMapping.class);
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSAppSetting)mongoTemplate.findOne(new Query(), MSAppSetting.class);
    }
}

