/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.mongo_device_utility.service;

import com.parablu.mongo_device_utility.config.MongoConnectionManager;
import com.parablu.mongo_device_utility.model.Device;
import com.parablu.mongo_device_utility.model.DeviceBackupOverview;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class DeviceService {
    private static final Logger logger = LoggerFactory.getLogger(DeviceService.class);
    private final MongoConnectionManager connectionManager;
    private final MongoTemplate mongoTemplate;
    private int totalUpdatedDevices = 0;
    private int totalUpdatedBlockedFields = 0;
    private int totalUpdatedDeletedFields = 0;

    public DeviceService(MongoConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.mongoTemplate = connectionManager.getMongoTemplateForClient("mongotemplate");
    }

    public void syncDevicesData(String connectionFilePath) {
        long startTime = System.currentTimeMillis();
        logger.info("STARTED: Syncing devices data with connection file:{}", (Object)connectionFilePath);
        try {
            List devices = this.mongoTemplate.findAll(Device.class);
            if (devices.isEmpty()) {
                logger.error("No devices found in the DEVICE collection.");
                return;
            }
            devices.forEach(device -> {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()));
                DeviceBackupOverview backupOverview = (DeviceBackupOverview)this.mongoTemplate.findOne(query, DeviceBackupOverview.class);
                if (backupOverview == null) {
                    logger.error("No backup overview found for device UUID: {}", (Object)device.getDeviceUUID());
                    return;
                }
                Update update = new Update();
                boolean updated = false;
                if (device.isBlocked() != backupOverview.isDeviceBolcked()) {
                    try {
                        update.set("isDeviceBolcked", (Object)device.isBlocked());
                        updated = true;
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while setting isDeviceBolcked field for device UUID: {}", (Object)device.getDeviceUUID(), (Object)e);
                    }
                }
                if (device.isDeleted() != backupOverview.isDeviceDeleted()) {
                    try {
                        update.set("isDeviceDeleted", (Object)device.isDeleted());
                        updated = true;
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while setting isDeviceDeleted field for device UUID: {}", (Object)device.getDeviceUUID(), (Object)e);
                    }
                }
                if (updated) {
                    this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, DeviceBackupOverview.class);
                    if (device.isBlocked() != backupOverview.isDeviceBolcked()) {
                        logger.info("Updated DEVICE_BACKUP_OVERVIEW for UUID: {} | isDeviceBlocked field updated from: {} to: {} (in DEVICE: {})", new Object[]{device.getDeviceUUID(), backupOverview.isDeviceBolcked(), device.isBlocked(), device.isBlocked()});
                        ++this.totalUpdatedBlockedFields;
                    }
                    if (device.isDeleted() != backupOverview.isDeviceDeleted()) {
                        logger.info("Updated DEVICE_BACKUP_OVERVIEW for UUID: {} | isDeviceDeleted field updated from: {} to: {} (in DEVICE: {})", new Object[]{device.getDeviceUUID(), backupOverview.isDeviceDeleted(), device.isDeleted(), device.isDeleted()});
                        ++this.totalUpdatedDeletedFields;
                    }
                    ++this.totalUpdatedDevices;
                }
            });
        }
        catch (Exception e) {
            logger.error("Error occurred while syncing data", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info("COMPLETED: Syncing devices data | Time taken: {} seconds", (Object)((endTime - startTime) / 1000L));
        logger.info("Total devices updated: {}", (Object)this.totalUpdatedDevices);
        logger.info("Total fields updated, Blocked: {} and Deleted: {}", (Object)this.totalUpdatedBlockedFields, (Object)this.totalUpdatedDeletedFields);
    }
}

