/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.SqlTypeValue;
import org.springframework.lang.Nullable;

public class SqlBinaryValue
implements SqlTypeValue {
    private final Object content;
    private final long length;

    public SqlBinaryValue(byte[] bytes) {
        this.content = bytes;
        this.length = bytes.length;
    }

    public SqlBinaryValue(InputStream stream, long length) {
        this.content = stream;
        this.length = length;
    }

    public SqlBinaryValue(InputStreamSource resource, long length) {
        this.content = resource;
        this.length = length;
    }

    public SqlBinaryValue(Resource resource) {
        this.content = resource;
        this.length = -1L;
    }

    @Override
    public void setTypeValue(PreparedStatement ps, int paramIndex, int sqlType, @Nullable String typeName) throws SQLException {
        Object object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            this.setByteArray(ps, paramIndex, sqlType, bytes);
        } else {
            object = this.content;
            if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                this.setInputStream(ps, paramIndex, sqlType, inputStream, this.length);
            } else {
                object = this.content;
                if (object instanceof Resource) {
                    Resource resource = (Resource)object;
                    try {
                        this.setInputStream(ps, paramIndex, sqlType, resource.getInputStream(), resource.contentLength());
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Cannot open binary stream for JDBC value: " + resource, ex);
                    }
                } else {
                    Object ex = this.content;
                    if (ex instanceof InputStreamSource) {
                        InputStreamSource resource = (InputStreamSource)ex;
                        try {
                            this.setInputStream(ps, paramIndex, sqlType, resource.getInputStream(), this.length);
                        }
                        catch (IOException ex2) {
                            throw new IllegalArgumentException("Cannot open binary stream for JDBC value: " + resource, ex2);
                        }
                    } else {
                        throw new IllegalArgumentException("Illegal content type: " + this.content.getClass().getName());
                    }
                }
            }
        }
    }

    private void setByteArray(PreparedStatement ps, int paramIndex, int sqlType, byte[] bytes) throws SQLException {
        if (sqlType == 2004) {
            ps.setBlob(paramIndex, new ByteArrayInputStream(bytes), bytes.length);
        } else {
            ps.setBytes(paramIndex, bytes);
        }
    }

    private void setInputStream(PreparedStatement ps, int paramIndex, int sqlType, InputStream is, long length) throws SQLException {
        if (sqlType == 2004) {
            ps.setBlob(paramIndex, is, length);
        } else {
            ps.setBinaryStream(paramIndex, is, length);
        }
    }
}

