/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.DesignDocument;
import org.lightcouch.NoDocumentException;
import org.lightcouch.Response;
import org.lightcouch.URIBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouchDbDesign {
    private static final String DESIGN_DOCS_DIR = "design-docs";
    private static final String JAVASCRIPT = "javascript";
    private static final String DESIGN_PREFIX = "_design/";
    private static final String VALIDATE_DOC = "validate_doc_update";
    private static final String VIEWS = "views";
    private static final String FILTERS = "filters";
    private static final String SHOWS = "shows";
    private static final String LISTS = "lists";
    private static final String UPDATES = "updates";
    private static final String REWRITES = "rewrites";
    private static final String FULLTEXT = "fulltext";
    private static final String INDEXES = "indexes";
    private static final String MAP_JS = "map.js";
    private static final String REDUCE_JS = "reduce.js";
    private CouchDbClientBase dbc;

    CouchDbDesign(CouchDbClientBase dbc) {
        this.dbc = dbc;
    }

    public Response synchronizeWithDb(DesignDocument document) {
        CouchDbUtil.assertNotEmpty(document, "Document");
        DesignDocument documentFromDb = null;
        try {
            documentFromDb = this.getFromDb(document.getId());
        }
        catch (NoDocumentException e) {
            return this.dbc.save(document);
        }
        if (!document.equals(documentFromDb)) {
            document.setRevision(documentFromDb.getRevision());
            return this.dbc.update(document);
        }
        return null;
    }

    public void synchronizeAllWithDb() {
        List<DesignDocument> documents = this.getAllFromDesk();
        for (DesignDocument dd : documents) {
            this.synchronizeWithDb(dd);
        }
    }

    public DesignDocument getFromDb(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        URI uri = URIBuilder.builder(this.dbc.getDBUri()).path(id).build();
        return this.dbc.get(uri, DesignDocument.class);
    }

    public DesignDocument getFromDb(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        URI uri = URIBuilder.builder(this.dbc.getDBUri()).path(id).query("rev", rev).build();
        return this.dbc.get(uri, DesignDocument.class);
    }

    public List<DesignDocument> getAllFromDesk() {
        ArrayList<DesignDocument> designDocsList = new ArrayList<DesignDocument>();
        for (String docName : CouchDbUtil.listResources(String.format("%s/", DESIGN_DOCS_DIR))) {
            designDocsList.add(this.getFromDesk(docName));
        }
        return designDocsList;
    }

    public DesignDocument getFromDesk(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        DesignDocument dd = new DesignDocument();
        String rootPath = String.format("%s/%s/", DESIGN_DOCS_DIR, id);
        List<String> elements = CouchDbUtil.listResources(rootPath);
        if (elements == null) {
            throw new IllegalArgumentException("Design docs directory cannot be empty.");
        }
        HashMap<String, DesignDocument.MapReduce> views = null;
        if (elements.contains(VIEWS)) {
            String viewsPath = String.format("%s%s/", rootPath, VIEWS);
            views = new HashMap<String, DesignDocument.MapReduce>();
            for (String viewDirName : CouchDbUtil.listResources(viewsPath)) {
                DesignDocument.MapReduce mr = new DesignDocument.MapReduce();
                String viewPath = String.format("%s%s/", viewsPath, viewDirName);
                List<String> dirList = CouchDbUtil.listResources(viewPath);
                for (String fileName : dirList) {
                    String def = CouchDbUtil.readFile(String.format("/%s%s", viewPath, fileName));
                    if (MAP_JS.equals(fileName)) {
                        mr.setMap(def);
                        continue;
                    }
                    if (!REDUCE_JS.equals(fileName)) continue;
                    mr.setReduce(def);
                }
                views.put(viewDirName, mr);
            }
        }
        dd.setId(DESIGN_PREFIX + id);
        dd.setLanguage(JAVASCRIPT);
        dd.setViews(views);
        dd.setFilters(this.populateMap(rootPath, elements, FILTERS));
        dd.setShows(this.populateMap(rootPath, elements, SHOWS));
        dd.setLists(this.populateMap(rootPath, elements, LISTS));
        dd.setUpdates(this.populateMap(rootPath, elements, UPDATES));
        dd.setValidateDocUpdate(this.readContent(elements, rootPath, VALIDATE_DOC));
        dd.setRewrites((JsonArray)this.dbc.getGson().fromJson(this.readContent(elements, rootPath, REWRITES), JsonArray.class));
        dd.setFulltext((JsonObject)this.dbc.getGson().fromJson(this.readContent(elements, rootPath, FULLTEXT), JsonObject.class));
        dd.setIndexes((JsonObject)this.dbc.getGson().fromJson(this.readContent(elements, rootPath, INDEXES), JsonObject.class));
        return dd;
    }

    private Map<String, String> populateMap(String rootPath, List<String> elements, String element) {
        HashMap<String, String> functionsMap = null;
        if (elements.contains(element)) {
            functionsMap = new HashMap<String, String>();
            String path = String.format("%s%s/", rootPath, element);
            for (String fileName : CouchDbUtil.listResources(path)) {
                String contents = CouchDbUtil.readFile(String.format("/%s%s", path, fileName));
                functionsMap.put(CouchDbUtil.removeExtension(fileName), contents);
            }
        }
        return functionsMap;
    }

    public String readContent(List<String> elements, String rootPath, String element) {
        String path;
        List<String> dirList;
        Iterator<String> i$;
        if (elements.contains(element) && (i$ = (dirList = CouchDbUtil.listResources(path = String.format("%s%s/", rootPath, element))).iterator()).hasNext()) {
            String file = i$.next();
            String contents = CouchDbUtil.readFile(String.format("/%s%s", path, file));
            return contents;
        }
        return null;
    }
}

