/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.MethodParameterAwarePagedResourcesAssembler;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MethodLinkBuilderFactory;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PagedResourcesAssemblerArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagedResourcesAssemblerArgumentResolver.class);
    private static final String SUPERFLOUS_QUALIFIER = "Found qualified {} parameter, but a unique unqualified {} parameter. Using that one, but you might wanna check your controller method configuration!";
    private static final String PARAMETER_AMBIGUITY = "Discovered muliple parameters of type Pageable but no qualifier annotations to disambiguate!";
    private final HateoasPageableHandlerMethodArgumentResolver resolver;
    private final MethodLinkBuilderFactory<?> linkBuilderFactory;

    public PagedResourcesAssemblerArgumentResolver(HateoasPageableHandlerMethodArgumentResolver resolver, @Nullable MethodLinkBuilderFactory<?> linkBuilderFactory) {
        this.resolver = resolver;
        this.linkBuilderFactory = linkBuilderFactory == null ? new ControllerLinkBuilderFactory() : linkBuilderFactory;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PagedResourcesAssembler.class.equals(parameter.getParameterType());
    }

    @Nonnull
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        UriComponents fromUriString = this.resolveBaseUri(parameter);
        MethodParameter pageableParameter = PagedResourcesAssemblerArgumentResolver.findMatchingPageableParameter(parameter);
        if (pageableParameter != null) {
            return new MethodParameterAwarePagedResourcesAssembler(pageableParameter, this.resolver, fromUriString);
        }
        return new PagedResourcesAssembler(this.resolver, fromUriString);
    }

    @Nullable
    private UriComponents resolveBaseUri(MethodParameter parameter) {
        try {
            Link linkToMethod = this.linkBuilderFactory.linkTo(parameter.getDeclaringClass(), parameter.getMethod(), new Object[0]).withSelfRel();
            return UriComponentsBuilder.fromUriString((String)linkToMethod.getHref()).build();
        }
        catch (IllegalArgumentException o_O) {
            return null;
        }
    }

    @Nullable
    private static MethodParameter findMatchingPageableParameter(MethodParameter parameter) {
        MethodParameters parameters = new MethodParameters(parameter.getMethod());
        List pageableParameters = parameters.getParametersOfType(Pageable.class);
        Qualifier assemblerQualifier = parameter.getParameterAnnotation(Qualifier.class);
        if (pageableParameters.isEmpty()) {
            return null;
        }
        if (pageableParameters.size() == 1) {
            MethodParameter pageableParameter = (MethodParameter)pageableParameters.get(0);
            MethodParameter matchingParameter = PagedResourcesAssemblerArgumentResolver.returnIfQualifiersMatch(pageableParameter, assemblerQualifier);
            if (matchingParameter == null) {
                LOGGER.info(SUPERFLOUS_QUALIFIER, (Object)PagedResourcesAssembler.class.getSimpleName(), (Object)Pageable.class.getName());
            }
            return pageableParameter;
        }
        if (assemblerQualifier == null) {
            throw new IllegalStateException(PARAMETER_AMBIGUITY);
        }
        for (MethodParameter pageableParameter : pageableParameters) {
            MethodParameter matchingParameter = PagedResourcesAssemblerArgumentResolver.returnIfQualifiersMatch(pageableParameter, assemblerQualifier);
            if (matchingParameter == null) continue;
            return matchingParameter;
        }
        throw new IllegalStateException(PARAMETER_AMBIGUITY);
    }

    @Nullable
    private static MethodParameter returnIfQualifiersMatch(MethodParameter pageableParameter, @Nullable Qualifier assemblerQualifier) {
        if (assemblerQualifier == null) {
            return pageableParameter;
        }
        Qualifier pageableParameterQualifier = pageableParameter.getParameterAnnotation(Qualifier.class);
        if (pageableParameterQualifier == null) {
            return null;
        }
        return pageableParameterQualifier.value().equals(assemblerQualifier.value()) ? pageableParameter : null;
    }
}

