/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.DefaultImplementationLookupConfiguration;
import org.springframework.data.repository.config.ImplementationLookupConfiguration;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public interface ImplementationDetectionConfiguration {
    public String getImplementationPostfix();

    public Streamable<String> getBasePackages();

    public Streamable<TypeFilter> getExcludeFilters();

    public MetadataReaderFactory getMetadataReaderFactory();

    default public String generateBeanName(BeanDefinition definition) {
        Assert.notNull((Object)definition, "BeanDefinition must not be null!");
        String beanName = definition.getBeanClassName();
        if (beanName == null) {
            throw new IllegalStateException("Cannot generate bean name for BeanDefinition without bean class name!");
        }
        return StringUtils.uncapitalize(ClassUtils.getShortName(beanName));
    }

    default public ImplementationLookupConfiguration forFragment(String fragmentInterfaceName) {
        Assert.hasText(fragmentInterfaceName, "Fragment interface name must not be null or empty!");
        return new DefaultImplementationLookupConfiguration(this, fragmentInterfaceName);
    }

    default public ImplementationLookupConfiguration forRepositoryConfiguration(final RepositoryConfiguration<?> config) {
        Assert.notNull(config, "RepositoryConfiguration must not be null!");
        return new DefaultImplementationLookupConfiguration(this, config.getRepositoryInterface()){

            @Override
            public Streamable<String> getBasePackages() {
                return config.getImplementationBasePackages();
            }
        };
    }
}

