/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.ReactiveMongoRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveMongoRepository<T, ID extends Serializable>
implements ReactiveMongoRepository<T, ID> {
    @NonNull
    private final MongoEntityInformation<T, ID> entityInformation;
    @NonNull
    private final ReactiveMongoOperations mongoOperations;

    @Override
    public Mono<T> findById(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        return this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, "The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public <S extends T> Mono<S> findOne(Example<S> example) {
        Assert.notNull(example, "Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        q.limit(2);
        return this.mongoOperations.find(q, example.getProbeType(), this.entityInformation.getCollectionName()).buffer(2).map(vals -> {
            if (vals.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            return vals.iterator().next();
        }).next();
    }

    @Override
    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        return this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, "The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        Assert.notNull(example, "Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        return this.mongoOperations.exists(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    @Override
    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, "The given Iterable of Id's must not be null!");
        return this.findAll(new Query(new Criteria(this.entityInformation.getIdAttribute()).in(Streamable.of(ids).stream().collect(StreamUtils.toUnmodifiableList()))));
    }

    @Override
    public Flux<T> findAllById(Publisher<ID> ids) {
        Assert.notNull(ids, "The given Publisher of Id's must not be null!");
        return Flux.from(ids).buffer().flatMap(this::findAllById);
    }

    @Override
    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        return this.findAll(new Query().with(sort));
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, "Sample must not be null!");
        Assert.notNull((Object)sort, "Sort must not be null!");
        Query query = new Query(new Criteria().alike(example)).with(sort);
        return this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> findAll(Example<S> example) {
        Assert.notNull(example, "Example must not be null!");
        return this.findAll(example, Sort.unsorted());
    }

    @Override
    public Mono<Long> count() {
        return this.mongoOperations.count(new Query(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Mono<Long> count(Example<S> example) {
        Assert.notNull(example, "Sample must not be null!");
        Query q = new Query(new Criteria().alike(example));
        return this.mongoOperations.count(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Mono<S> insert(S entity) {
        Assert.notNull(entity, "Entity must not be null!");
        return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, "The given Iterable of entities must not be null!");
        List source = Streamable.of(entities).stream().collect(StreamUtils.toUnmodifiableList());
        return source.isEmpty() ? Flux.empty() : Flux.from(this.mongoOperations.insertAll(source));
    }

    @Override
    public <S extends T> Flux<S> insert(Publisher<S> entities) {
        Assert.notNull(entities, "The given Publisher of entities must not be null!");
        return Flux.from(entities).flatMap(entity -> this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()));
    }

    @Override
    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, "Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        }
        return this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, "The given Iterable of entities must not be null!");
        Streamable<S> source = Streamable.of(entities);
        return source.stream().allMatch(this.entityInformation::isNew) ? this.mongoOperations.insert((Collection)source.stream().collect(Collectors.toList()), this.entityInformation.getCollectionName()) : Flux.fromIterable(entities).flatMap(this::save);
    }

    @Override
    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, "The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(entity -> this.entityInformation.isNew(entity) ? this.mongoOperations.insert(entity, this.entityInformation.getCollectionName()).then(Mono.just((Object)entity)) : this.mongoOperations.save(entity, this.entityInformation.getCollectionName()).then(Mono.just((Object)entity)));
    }

    @Override
    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, "The given id must not be null!");
        return this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).then();
    }

    @Override
    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, "Id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName())).then();
    }

    @Override
    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, "The given entity must not be null!");
        return this.deleteById((ID)((Serializable)this.entityInformation.getRequiredId(entity)));
    }

    @Override
    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, "The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(entity -> this.deleteById((ID)((Serializable)this.entityInformation.getRequiredId(entity)))).then();
    }

    @Override
    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, "The given Publisher of entities must not be null!");
        return Flux.from(entityStream).map(this.entityInformation::getRequiredId).flatMap(this::deleteById).then();
    }

    @Override
    public Mono<Void> deleteAll() {
        return this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName()).then(Mono.empty());
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    private Flux<T> findAll(Query query) {
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public SimpleReactiveMongoRepository(@NonNull MongoEntityInformation<T, ID> entityInformation, @NonNull ReactiveMongoOperations mongoOperations) {
        if (entityInformation == null) {
            throw new IllegalArgumentException("entityInformation is marked @NonNull but is null");
        }
        if (mongoOperations == null) {
            throw new IllegalArgumentException("mongoOperations is marked @NonNull but is null");
        }
        this.entityInformation = entityInformation;
        this.mongoOperations = mongoOperations;
    }
}

