/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.Fetchable;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.support.MongodbDocumentSerializer;
import org.springframework.data.mongodb.repository.support.QuerydslAbstractMongodbQuery;
import org.springframework.data.mongodb.repository.support.QuerydslAnyEmbeddedBuilder;
import org.springframework.data.mongodb.repository.support.QuerydslJoinBuilder;
import org.springframework.data.mongodb.repository.support.QuerydslMongoOps;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;

abstract class QuerydslFetchableMongodbQuery<K, Q extends QuerydslFetchableMongodbQuery<K, Q>>
extends QuerydslAbstractMongodbQuery<K, Q>
implements Fetchable<K> {
    private final Class<K> entityClass;
    private final String collection;
    private final MongoOperations mongoOperations;
    private final ExecutableFindOperation.FindWithProjection<K> find;

    QuerydslFetchableMongodbQuery(MongodbDocumentSerializer serializer, Class<? extends K> entityClass, String collection, MongoOperations mongoOperations) {
        super(serializer);
        this.entityClass = entityClass;
        this.collection = collection;
        this.mongoOperations = mongoOperations;
        this.find = mongoOperations.query(this.entityClass).inCollection(collection);
    }

    public com.mysema.commons.lang.CloseableIterator<K> iterate() {
        final CloseableIterator<K> stream = this.mongoOperations.stream(this.createQuery(), this.entityClass, this.collection);
        return new com.mysema.commons.lang.CloseableIterator<K>(){

            public boolean hasNext() {
                return stream.hasNext();
            }

            public K next() {
                return stream.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from iterator while streaming data.");
            }

            public void close() {
                stream.close();
            }
        };
    }

    public List<K> fetch() {
        return this.find.matching(this.createQuery()).all();
    }

    public K fetchFirst() {
        return (K)this.find.matching(this.createQuery()).firstValue();
    }

    public K fetchOne() {
        return (K)this.find.matching(this.createQuery()).oneValue();
    }

    public QueryResults<K> fetchResults() {
        long total = this.fetchCount();
        return total > 0L ? new QueryResults(this.fetch(), this.getQueryMixin().getMetadata().getModifiers(), total) : QueryResults.emptyResults();
    }

    public long fetchCount() {
        return this.find.matching(this.createQuery()).count();
    }

    public <T> QuerydslJoinBuilder<Q, K, T> join(Path<T> ref, Path<T> target) {
        return new QuerydslJoinBuilder(this.getQueryMixin(), ref, target);
    }

    public <T> QuerydslJoinBuilder<Q, K, T> join(CollectionPathBase<?, T, ?> ref, Path<T> target) {
        return new QuerydslJoinBuilder(this.getQueryMixin(), (Path<?>)ref, target);
    }

    public <T> QuerydslAnyEmbeddedBuilder<Q, K> anyEmbedded(Path<? extends Collection<T>> collection, Path<T> target) {
        return new QuerydslAnyEmbeddedBuilder(this.getQueryMixin(), collection);
    }

    protected Query createQuery() {
        QueryMetadata metadata = this.getQueryMixin().getMetadata();
        return this.createQuery(this.createFilter(metadata), metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    protected Query createQuery(@Nullable Predicate filter, @Nullable Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        BasicQuery basicQuery = new BasicQuery(this.createQuery(filter), this.createProjection(projection));
        Integer limit = modifiers.getLimitAsInteger();
        Integer offset = modifiers.getOffsetAsInteger();
        if (limit != null) {
            basicQuery.limit(limit);
        }
        if (offset != null) {
            basicQuery.skip(offset.intValue());
        }
        if (orderBy.size() > 0) {
            basicQuery.setSortObject(this.createSort(orderBy));
        }
        return basicQuery;
    }

    @Nullable
    protected Predicate createFilter(QueryMetadata metadata) {
        Predicate filter = !metadata.getJoins().isEmpty() ? ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), this.createJoinFilter(metadata)}) : metadata.getWhere();
        return filter;
    }

    @Nullable
    protected Predicate createJoinFilter(QueryMetadata metadata) {
        LinkedMultiValueMap<Path, Predicate> predicates = new LinkedMultiValueMap<Path, Predicate>();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Object extraFilters = predicates.get(target.getRoot());
            Predicate filter = ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), this.allOf((Collection<Predicate>)extraFilters)});
            List<Object> ids = this.getIds(target.getType(), filter);
            if (ids.isEmpty()) {
                return ExpressionUtils.predicate((Operator)QuerydslMongoOps.NO_MATCH, (Expression[])new Expression[]{source});
            }
            Path path = ExpressionUtils.path(String.class, (Path)source, (String)"$id");
            predicates.add(source.getRoot(), ExpressionUtils.in((Expression)path, ids));
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return this.allOf((Collection<Predicate>)predicates.get(source.getRoot()));
    }

    private Predicate allOf(Collection<Predicate> predicates) {
        return predicates != null ? ExpressionUtils.allOf(predicates) : null;
    }

    protected List<Object> getIds(Class<?> targetType, Predicate condition) {
        Query query = this.createQuery(condition, null, QueryModifiers.EMPTY, Collections.emptyList());
        return this.mongoOperations.findDistinct(query, "_id", targetType, Object.class);
    }
}

