/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.mongodb.repository.query.ReactiveMongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryExecution;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveMongoQuery
implements RepositoryQuery {
    private final ReactiveMongoQueryMethod method;
    private final ReactiveMongoOperations operations;
    private final EntityInstantiators instantiators;
    private final ReactiveFindOperation.FindWithProjection<?> findOperationWithProjection;

    public AbstractReactiveMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations operations) {
        Assert.notNull((Object)method, "MongoQueryMethod must not be null!");
        Assert.notNull((Object)operations, "ReactiveMongoOperations must not be null!");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getCollectionEntity().getType();
        this.findOperationWithProjection = operations.query(type);
    }

    @Override
    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    @Override
    public Object execute(Object[] parameters) {
        return this.method.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute(new MongoParametersParameterAccessor(this.method, parameters));
    }

    private Object executeDeferred(Object[] parameters) {
        ReactiveMongoParameterAccessor parameterAccessor = new ReactiveMongoParameterAccessor(this.method, parameters);
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute(parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute(parameterAccessor));
    }

    private Object execute(MongoParameterAccessor parameterAccessor) {
        Query query = this.createQuery(new ConvertingParameterAccessor(this.operations.getConverter(), parameterAccessor));
        this.applyQueryMetaAttributesWhenPresent(query);
        query = this.applyAnnotatedDefaultSortIfPresent(query);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection(parameterAccessor);
        Class<?> typeToRead = processor.getReturnedType().getTypeToRead();
        ReactiveFindOperation.FindWithProjection<?> find = typeToRead == null ? this.findOperationWithProjection : this.findOperationWithProjection.as(typeToRead);
        String collection = this.method.getEntityInformation().getCollectionName();
        ReactiveMongoQueryExecution execution = this.getExecution(parameterAccessor, new ReactiveMongoQueryExecution.ResultProcessingConverter(processor, this.operations, this.instantiators), find);
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private ReactiveMongoQueryExecution getExecution(MongoParameterAccessor accessor, Converter<Object, Object> resultProcessing, ReactiveFindOperation.FindWithQuery<?> operation) {
        return new ReactiveMongoQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private ReactiveMongoQueryExecution getExecutionToWrap(MongoParameterAccessor accessor, ReactiveFindOperation.FindWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new ReactiveMongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isGeoNearQuery()) {
            return new ReactiveMongoQueryExecution.GeoNearExecution(this.operations, accessor, this.method.getReturnType());
        }
        if (this.isTailable(this.method)) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).tail();
        }
        if (this.method.isCollectionQuery()) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).all();
        }
        if (this.isCountQuery()) {
            return (q, t, c) -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, c) -> operation.matching(q).exists();
        }
        return (q, t, c) -> {
            ReactiveFindOperation.TerminatingFind find = operation.matching(q);
            if (this.isCountQuery()) {
                return find.count();
            }
            return this.isLimiting() ? find.first() : find.one();
        };
    }

    private boolean isTailable(MongoQueryMethod method) {
        return method.getTailableAnnotation() != null;
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    Query applyAnnotatedDefaultSortIfPresent(Query query) {
        if (!this.method.hasAnnotatedSort()) {
            return query;
        }
        return QueryUtils.decorateSort(query, Document.parse(this.method.getAnnotatedSort()));
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isLimiting();
}

