/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;

public abstract class AbstractMonitor {
    private final MongoClient mongoClient;

    protected AbstractMonitor(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public Document getServerStatus() {
        return this.getDb("admin").runCommand(new Document("serverStatus", 1).append("rangeDeleter", 1).append("repl", 1));
    }

    public MongoDatabase getDb(String databaseName) {
        return this.mongoClient.getDatabase(databaseName);
    }

    protected MongoClient getMongoClient() {
        return this.mongoClient;
    }
}

