/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.util.Assert;

class JsonSchemaValidator
implements Validator {
    private final MongoJsonSchema schema;

    static JsonSchemaValidator of(MongoJsonSchema schema) {
        Assert.notNull((Object)schema, "Schema must not be null!");
        return new JsonSchemaValidator(schema);
    }

    @Override
    public Document toDocument() {
        return this.schema.toDocument();
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDocument());
    }

    private JsonSchemaValidator(MongoJsonSchema schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonSchemaValidator)) {
            return false;
        }
        JsonSchemaValidator other = (JsonSchemaValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongoJsonSchema this$schema = this.schema;
        MongoJsonSchema other$schema = other.schema;
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonSchemaValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongoJsonSchema $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }
}

