/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

abstract class MongoConverters {
    private MongoConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add(BigDecimalToStringConverter.INSTANCE);
        converters.add(StringToBigDecimalConverter.INSTANCE);
        converters.add(BigIntegerToStringConverter.INSTANCE);
        converters.add(StringToBigIntegerConverter.INSTANCE);
        converters.add(URLToStringConverter.INSTANCE);
        converters.add(StringToURLConverter.INSTANCE);
        converters.add(DocumentToStringConverter.INSTANCE);
        converters.add(TermToStringConverter.INSTANCE);
        converters.add(NamedMongoScriptToDocumentConverter.INSTANCE);
        converters.add(DocumentToNamedMongoScriptConverter.INSTANCE);
        converters.add(CurrencyToStringConverter.INSTANCE);
        converters.add(StringToCurrencyConverter.INSTANCE);
        converters.add(AtomicIntegerToIntegerConverter.INSTANCE);
        converters.add(AtomicLongToLongConverter.INSTANCE);
        converters.add(LongToAtomicLongConverter.INSTANCE);
        converters.add(IntegerToAtomicIntegerConverter.INSTANCE);
        converters.add(BinaryToByteArrayConverter.INSTANCE);
        converters.add(BsonTimestampToInstantConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    static enum BsonTimestampToInstantConverter implements Converter<BsonTimestamp, Instant>
    {
        INSTANCE;


        @Override
        @Nullable
        public Instant convert(BsonTimestamp source) {
            return Instant.ofEpochSecond(source.getTime(), 0L);
        }
    }

    @ReadingConverter
    static enum BinaryToByteArrayConverter implements Converter<Binary, byte[]>
    {
        INSTANCE;


        @Override
        @Nullable
        public byte[] convert(Binary source) {
            return source.getData();
        }
    }

    @ReadingConverter
    static enum IntegerToAtomicIntegerConverter implements Converter<Integer, AtomicInteger>
    {
        INSTANCE;


        @Override
        public AtomicInteger convert(Integer source) {
            return source != null ? new AtomicInteger(source) : null;
        }
    }

    @ReadingConverter
    static enum LongToAtomicLongConverter implements Converter<Long, AtomicLong>
    {
        INSTANCE;


        @Override
        public AtomicLong convert(Long source) {
            return source != null ? new AtomicLong(source) : null;
        }
    }

    @WritingConverter
    static enum AtomicIntegerToIntegerConverter implements Converter<AtomicInteger, Integer>
    {
        INSTANCE;


        @Override
        public Integer convert(AtomicInteger source) {
            return NumberUtils.convertNumberToTargetClass(source, Integer.class);
        }
    }

    @WritingConverter
    static enum AtomicLongToLongConverter implements Converter<AtomicLong, Long>
    {
        INSTANCE;


        @Override
        public Long convert(AtomicLong source) {
            return NumberUtils.convertNumberToTargetClass(source, Long.class);
        }
    }

    @WritingConverter
    static enum NumberToNumberConverterFactory implements ConverterFactory<Number, Number>,
    ConditionalConverter
    {
        INSTANCE;


        @Override
        public <T extends Number> Converter<Number, T> getConverter(Class<T> targetType) {
            return new NumberToNumberConverter<T>(targetType);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return !sourceType.equals(targetType);
        }

        private static final class NumberToNumberConverter<T extends Number>
        implements Converter<Number, T> {
            private final Class<T> targetType;

            public NumberToNumberConverter(Class<T> targetType) {
                Assert.notNull(targetType, "Target type must not be null!");
                this.targetType = targetType;
            }

            @Override
            public T convert(Number source) {
                if (source instanceof AtomicInteger) {
                    return NumberUtils.convertNumberToTargetClass(((AtomicInteger)source).get(), this.targetType);
                }
                if (source instanceof AtomicLong) {
                    return NumberUtils.convertNumberToTargetClass(((AtomicLong)source).get(), this.targetType);
                }
                return NumberUtils.convertNumberToTargetClass(source, this.targetType);
            }
        }
    }

    @ReadingConverter
    static enum StringToCurrencyConverter implements Converter<String, Currency>
    {
        INSTANCE;


        @Override
        public Currency convert(String source) {
            return StringUtils.hasText(source) ? Currency.getInstance(source) : null;
        }
    }

    @WritingConverter
    static enum CurrencyToStringConverter implements Converter<Currency, String>
    {
        INSTANCE;


        @Override
        public String convert(Currency source) {
            return source == null ? null : source.getCurrencyCode();
        }
    }

    static enum NamedMongoScriptToDocumentConverter implements Converter<NamedMongoScript, Document>
    {
        INSTANCE;


        @Override
        public Document convert(NamedMongoScript source) {
            if (source == null) {
                return new Document();
            }
            Document document = new Document();
            document.put("_id", (Object)source.getName());
            document.put("value", (Object)new Code(source.getCode()));
            return document;
        }
    }

    static enum DocumentToNamedMongoScriptConverter implements Converter<Document, NamedMongoScript>
    {
        INSTANCE;


        @Override
        public NamedMongoScript convert(Document source) {
            if (source == null) {
                return null;
            }
            String id = source.get("_id").toString();
            Object rawValue = source.get("value");
            return new NamedMongoScript(id, ((Code)rawValue).getCode());
        }
    }

    @WritingConverter
    static enum TermToStringConverter implements Converter<Term, String>
    {
        INSTANCE;


        @Override
        public String convert(Term source) {
            return source == null ? null : source.getFormatted();
        }
    }

    @ReadingConverter
    static enum DocumentToStringConverter implements Converter<Document, String>
    {
        INSTANCE;


        @Override
        public String convert(Document source) {
            if (source == null) {
                return null;
            }
            return source.toJson();
        }
    }

    static enum StringToURLConverter implements Converter<String, URL>
    {
        INSTANCE;

        private static final TypeDescriptor SOURCE;
        private static final TypeDescriptor TARGET;

        @Override
        public URL convert(String source) {
            try {
                return source == null ? null : new URL(source);
            }
            catch (MalformedURLException e) {
                throw new ConversionFailedException(SOURCE, TARGET, source, e);
            }
        }

        static {
            SOURCE = TypeDescriptor.valueOf(String.class);
            TARGET = TypeDescriptor.valueOf(URL.class);
        }
    }

    static enum URLToStringConverter implements Converter<URL, String>
    {
        INSTANCE;


        @Override
        public String convert(URL source) {
            return source == null ? null : source.toString();
        }
    }

    static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        @Override
        public BigInteger convert(String source) {
            return StringUtils.hasText(source) ? new BigInteger(source) : null;
        }
    }

    static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        @Override
        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        @Override
        public BigDecimal convert(String source) {
            return StringUtils.hasText(source) ? new BigDecimal(source) : null;
        }
    }

    static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        @Override
        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        @Override
        public ObjectId convert(BigInteger source) {
            return source == null ? null : new ObjectId(source.toString(16));
        }
    }

    static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        @Override
        public BigInteger convert(ObjectId source) {
            return source == null ? null : new BigInteger(source.toString(), 16);
        }
    }

    static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        @Override
        public ObjectId convert(String source) {
            return StringUtils.hasText(source) ? new ObjectId(source) : null;
        }
    }

    static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        @Override
        public String convert(ObjectId id) {
            return id == null ? null : id.toString();
        }
    }
}

