/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.Map;
import org.bson.Document;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.lang.Nullable;

class DocumentPropertyAccessor
extends MapAccessor {
    static final MapAccessor INSTANCE = new DocumentPropertyAccessor();

    DocumentPropertyAccessor() {
    }

    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Document.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
        return true;
    }

    @Override
    public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
        if (target == null) {
            return TypedValue.NULL;
        }
        Map source = (Map)target;
        Object value = source.get(name);
        return value == null ? TypedValue.NULL : new TypedValue(value);
    }
}

