/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

public class TypeBasedAggregationOperationContext
implements AggregationOperationContext {
    private final Class<?> type;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public TypeBasedAggregationOperationContext(Class<?> type, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, QueryMapper mapper) {
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull(mappingContext, "MappingContext must not be null!");
        Assert.notNull((Object)mapper, "QueryMapper must not be null!");
        this.type = type;
        this.mappingContext = mappingContext;
        this.mapper = mapper;
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.mapper.getMappedObject((Bson)document, this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)this.type)));
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        PropertyPath.from(field.getTarget(), this.type);
        return this.getReferenceFor(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.getReferenceFor(Fields.field(name));
    }

    private ExposedFields.FieldReference getReferenceFor(Field field) {
        PersistentPropertyPath<MongoPersistentProperty> propertyPath = this.mappingContext.getPersistentPropertyPath(field.getTarget(), this.type);
        Field mappedField = Fields.field(field.getName(), propertyPath.toDotPath(MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE));
        return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(mappedField, true));
    }
}

