/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;

public class PrefixingDelegatingAggregationOperationContext
implements AggregationOperationContext {
    private final AggregationOperationContext delegate;
    private final String prefix;
    private final Set<String> blacklist;

    public PrefixingDelegatingAggregationOperationContext(AggregationOperationContext delegate, String prefix) {
        this(delegate, prefix, Collections.emptySet());
    }

    public PrefixingDelegatingAggregationOperationContext(AggregationOperationContext delegate, String prefix, Collection<String> blacklist) {
        this.delegate = delegate;
        this.prefix = prefix;
        this.blacklist = new HashSet<String>(blacklist);
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.doPrefix(this.delegate.getMappedObject(document));
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return this.delegate.getReference(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.delegate.getReference(name);
    }

    private Document doPrefix(Document source) {
        Document result = new Document();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = this.prefixKey(entry.getKey());
            Object value = entry.getValue();
            if (entry.getValue() instanceof Collection) {
                Collection sourceCollection = (Collection)entry.getValue();
                value = this.prefixCollection(sourceCollection);
            }
            result.append(key, value);
        }
        return result;
    }

    private String prefixKey(String key) {
        return key.startsWith("$") || this.isBlacklisted(key) ? key : this.prefix + "." + key;
    }

    private Object prefixCollection(Collection<Object> sourceCollection) {
        ArrayList<Object> prefixed = new ArrayList<Object>(sourceCollection.size());
        for (Object o : sourceCollection) {
            if (o instanceof Document) {
                prefixed.add(this.doPrefix((Document)o));
                continue;
            }
            prefixed.add(o);
        }
        return prefixed;
    }

    private boolean isBlacklisted(String key) {
        if (this.blacklist.contains(key)) {
            return true;
        }
        if (!key.contains(".")) {
            return false;
        }
        for (String blacklisted : this.blacklist) {
            if (!key.startsWith(blacklisted + ".")) continue;
            return true;
        }
        return false;
    }
}

