/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GroupOperation
implements FieldsExposingAggregationOperation {
    private final ExposedFields idFields;
    private final List<Operation> operations;

    public GroupOperation(Fields fields) {
        this.idFields = ExposedFields.nonSynthetic(fields);
        this.operations = new ArrayList<Operation>();
    }

    protected GroupOperation(GroupOperation groupOperation) {
        this(groupOperation, Collections.emptyList());
    }

    private GroupOperation(GroupOperation groupOperation, List<Operation> nextOperations) {
        Assert.notNull((Object)groupOperation, "GroupOperation must not be null!");
        Assert.notNull(nextOperations, "NextOperations must not be null!");
        this.idFields = groupOperation.idFields;
        this.operations = new ArrayList<Operation>(nextOperations.size() + 1);
        this.operations.addAll(groupOperation.operations);
        this.operations.addAll(nextOperations);
    }

    protected GroupOperation and(Operation operation) {
        return new GroupOperation(this, Arrays.asList(operation));
    }

    public GroupOperationBuilder count() {
        return this.newBuilder(GroupOps.SUM, null, 1);
    }

    public GroupOperationBuilder sum(String reference) {
        return this.sum(reference, null);
    }

    public GroupOperationBuilder sum(AggregationExpression expr) {
        Assert.notNull((Object)expr, "Expr must not be null!");
        return this.newBuilder(GroupOps.SUM, null, expr);
    }

    private GroupOperationBuilder sum(@Nullable String reference, @Nullable Object value) {
        return this.newBuilder(GroupOps.SUM, reference, value);
    }

    public GroupOperationBuilder addToSet(String reference) {
        return this.addToSet(reference, null);
    }

    public GroupOperationBuilder addToSet(Object value) {
        return this.addToSet(null, value);
    }

    private GroupOperationBuilder addToSet(@Nullable String reference, @Nullable Object value) {
        return this.newBuilder(GroupOps.ADD_TO_SET, reference, value);
    }

    public GroupOperationBuilder last(String reference) {
        return this.newBuilder(GroupOps.LAST, reference, null);
    }

    public GroupOperationBuilder last(AggregationExpression expr) {
        return this.newBuilder(GroupOps.LAST, null, expr);
    }

    public GroupOperationBuilder first(String reference) {
        return this.newBuilder(GroupOps.FIRST, reference, null);
    }

    public GroupOperationBuilder first(AggregationExpression expr) {
        return this.newBuilder(GroupOps.FIRST, null, expr);
    }

    public GroupOperationBuilder avg(String reference) {
        return this.newBuilder(GroupOps.AVG, reference, null);
    }

    public GroupOperationBuilder avg(AggregationExpression expr) {
        return this.newBuilder(GroupOps.AVG, null, expr);
    }

    public GroupOperationBuilder push(String reference) {
        return this.push(reference, null);
    }

    public GroupOperationBuilder push(Object value) {
        return this.push(null, value);
    }

    private GroupOperationBuilder push(@Nullable String reference, @Nullable Object value) {
        return this.newBuilder(GroupOps.PUSH, reference, value);
    }

    public GroupOperationBuilder min(String reference) {
        return this.newBuilder(GroupOps.MIN, reference, null);
    }

    public GroupOperationBuilder min(AggregationExpression expr) {
        return this.newBuilder(GroupOps.MIN, null, expr);
    }

    public GroupOperationBuilder max(String reference) {
        return this.newBuilder(GroupOps.MAX, reference, null);
    }

    public GroupOperationBuilder max(AggregationExpression expr) {
        return this.newBuilder(GroupOps.MAX, null, expr);
    }

    public GroupOperationBuilder stdDevSamp(String reference) {
        return this.newBuilder(GroupOps.STD_DEV_SAMP, reference, null);
    }

    public GroupOperationBuilder stdDevSamp(AggregationExpression expr) {
        return this.newBuilder(GroupOps.STD_DEV_SAMP, null, expr);
    }

    public GroupOperationBuilder stdDevPop(String reference) {
        return this.newBuilder(GroupOps.STD_DEV_POP, reference, null);
    }

    public GroupOperationBuilder stdDevPop(AggregationExpression expr) {
        return this.newBuilder(GroupOps.STD_DEV_POP, null, expr);
    }

    private GroupOperationBuilder newBuilder(Keyword keyword, @Nullable String reference, @Nullable Object value) {
        return new GroupOperationBuilder(this, new Operation(keyword, null, reference, value));
    }

    @Override
    public ExposedFields getFields() {
        ExposedFields fields = this.idFields.and(new ExposedFields.ExposedField("_id", true));
        for (Operation operation : this.operations) {
            fields = fields.and(operation.asField());
        }
        return fields;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document operationObject = new Document();
        if (this.idFields.exposesNoNonSyntheticFields()) {
            operationObject.put("_id", (Object)null);
        } else if (this.idFields.exposesSingleNonSyntheticFieldOnly()) {
            ExposedFields.FieldReference reference = context.getReference(this.idFields.iterator().next());
            operationObject.put("_id", (Object)reference.toString());
        } else {
            Document inner = new Document();
            for (ExposedFields.ExposedField field : this.idFields) {
                ExposedFields.FieldReference reference = context.getReference(field);
                inner.put(field.getName(), (Object)reference.toString());
            }
            operationObject.put("_id", (Object)inner);
        }
        for (Operation operation : this.operations) {
            operationObject.putAll(operation.toDocument(context));
        }
        return new Document("$group", operationObject);
    }

    static class Operation
    implements AggregationOperation {
        private final Keyword op;
        @Nullable
        private final String key;
        @Nullable
        private final String reference;
        @Nullable
        private final Object value;

        public Operation(Keyword op, @Nullable String key, @Nullable String reference, @Nullable Object value) {
            this.op = op;
            this.key = key;
            this.reference = reference;
            this.value = value;
        }

        public Operation withAlias(String key) {
            return new Operation(this.op, key, this.reference, this.value);
        }

        public ExposedFields.ExposedField asField() {
            return new ExposedFields.ExposedField(this.key, true);
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document(this.key, new Document(this.op.toString(), this.getValue(context)));
        }

        public Object getValue(AggregationOperationContext context) {
            if (this.reference == null) {
                if (this.value instanceof AggregationExpression) {
                    return ((AggregationExpression)this.value).toDocument(context);
                }
                return this.value;
            }
            if (Aggregation.SystemVariable.isReferingToSystemVariable(this.reference)) {
                return this.reference;
            }
            return context.getReference(this.reference).toString();
        }

        public String toString() {
            return "Operation [op=" + this.op + ", key=" + this.key + ", reference=" + this.reference + ", value=" + this.value + "]";
        }
    }

    private static enum GroupOps implements Keyword
    {
        SUM("$sum"),
        LAST("$last"),
        FIRST("$first"),
        PUSH("$push"),
        AVG("$avg"),
        MIN("$min"),
        MAX("$max"),
        ADD_TO_SET("$addToSet"),
        STD_DEV_POP("$stdDevPop"),
        STD_DEV_SAMP("$stdDevSamp");

        private String mongoOperator;

        private GroupOps(String mongoOperator) {
            this.mongoOperator = mongoOperator;
        }

        @Override
        public String toString() {
            return this.mongoOperator;
        }
    }

    static interface Keyword {
        public String toString();
    }

    public static final class GroupOperationBuilder {
        private final GroupOperation groupOperation;
        private final Operation operation;

        private GroupOperationBuilder(GroupOperation groupOperation, Operation operation) {
            Assert.notNull((Object)groupOperation, "GroupOperation must not be null!");
            Assert.notNull((Object)operation, "Operation must not be null!");
            this.groupOperation = groupOperation;
            this.operation = operation;
        }

        public GroupOperation as(String alias) {
            return this.groupOperation.and(this.operation.withAlias(alias));
        }
    }
}

