/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactoryFactory;
import java.util.ArrayList;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class ReactiveMongoClientSettingsFactoryBean
extends AbstractFactoryBean<MongoClientSettings> {
    private static final MongoClientSettings DEFAULT_MONGO_SETTINGS = MongoClientSettings.builder().build();
    private ReadPreference readPreference = DEFAULT_MONGO_SETTINGS.getReadPreference();
    private WriteConcern writeConcern = DEFAULT_MONGO_SETTINGS.getWriteConcern();
    private ReadConcern readConcern = DEFAULT_MONGO_SETTINGS.getReadConcern();
    private List<MongoCredential> credentialList = new ArrayList<MongoCredential>();
    private StreamFactoryFactory streamFactoryFactory = DEFAULT_MONGO_SETTINGS.getStreamFactoryFactory();
    private CodecRegistry codecRegistry = DEFAULT_MONGO_SETTINGS.getCodecRegistry();
    private ClusterSettings clusterSettings = DEFAULT_MONGO_SETTINGS.getClusterSettings();
    private SocketSettings socketSettings = DEFAULT_MONGO_SETTINGS.getSocketSettings();
    private SocketSettings heartbeatSocketSettings = DEFAULT_MONGO_SETTINGS.getHeartbeatSocketSettings();
    private ConnectionPoolSettings connectionPoolSettings = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings();
    private ServerSettings serverSettings = DEFAULT_MONGO_SETTINGS.getServerSettings();
    private SslSettings sslSettings = DEFAULT_MONGO_SETTINGS.getSslSettings();

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    public void setCredentialList(List<MongoCredential> credentialList) {
        Assert.notNull(credentialList, "CredendialList must not be null!");
        this.credentialList.addAll(credentialList);
    }

    public void addMongoCredential(MongoCredential mongoCredential) {
        Assert.notNull((Object)mongoCredential, "MongoCredential must not be null!");
        this.credentialList.add(mongoCredential);
    }

    public void setStreamFactoryFactory(StreamFactoryFactory streamFactoryFactory) {
        this.streamFactoryFactory = streamFactoryFactory;
    }

    public void setCodecRegistry(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public void setClusterSettings(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    public void setSocketSettings(SocketSettings socketSettings) {
        this.socketSettings = socketSettings;
    }

    public void setHeartbeatSocketSettings(SocketSettings heartbeatSocketSettings) {
        this.heartbeatSocketSettings = heartbeatSocketSettings;
    }

    public void setConnectionPoolSettings(ConnectionPoolSettings connectionPoolSettings) {
        this.connectionPoolSettings = connectionPoolSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public void setSslSettings(SslSettings sslSettings) {
        this.sslSettings = sslSettings;
    }

    @Override
    public Class<?> getObjectType() {
        return MongoClientSettings.class;
    }

    @Override
    protected MongoClientSettings createInstance() throws Exception {
        return MongoClientSettings.builder().readPreference(this.readPreference).writeConcern(this.writeConcern).readConcern(this.readConcern).credentialList(this.credentialList).streamFactoryFactory(this.streamFactoryFactory).codecRegistry(this.codecRegistry).clusterSettings(this.clusterSettings).socketSettings(this.socketSettings).heartbeatSocketSettings(this.heartbeatSocketSettings).connectionPoolSettings(this.connectionPoolSettings).serverSettings(this.serverSettings).sslSettings(this.sslSettings).build();
    }
}

