/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.IndexOptions;
import java.util.Collection;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.ReactiveIndexOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveIndexOperations
implements ReactiveIndexOperations {
    private static final String PARTIAL_FILTER_EXPRESSION_KEY = "partialFilterExpression";
    private final ReactiveMongoOperations mongoOperations;
    private final String collectionName;
    private final QueryMapper queryMapper;
    private final Optional<Class<?>> type;

    public DefaultReactiveIndexOperations(ReactiveMongoOperations mongoOperations, String collectionName, QueryMapper queryMapper) {
        this(mongoOperations, collectionName, queryMapper, Optional.empty());
    }

    public DefaultReactiveIndexOperations(ReactiveMongoOperations mongoOperations, String collectionName, QueryMapper queryMapper, Class<?> type) {
        this(mongoOperations, collectionName, queryMapper, Optional.of(type));
    }

    private DefaultReactiveIndexOperations(ReactiveMongoOperations mongoOperations, String collectionName, QueryMapper queryMapper, Optional<Class<?>> type) {
        Assert.notNull((Object)mongoOperations, "ReactiveMongoOperations must not be null!");
        Assert.notNull((Object)collectionName, "Collection must not be null!");
        Assert.notNull((Object)queryMapper, "QueryMapper must not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.queryMapper = queryMapper;
        this.type = type;
    }

    @Override
    public Mono<String> ensureIndex(IndexDefinition indexDefinition) {
        return this.mongoOperations.execute(this.collectionName, collection -> {
            Document indexOptions = indexDefinition.getIndexOptions();
            IndexOptions ops = IndexConverters.indexDefinitionToIndexOptionsConverter().convert(indexDefinition);
            if (indexOptions.containsKey(PARTIAL_FILTER_EXPRESSION_KEY)) {
                Assert.isInstanceOf(Document.class, indexOptions.get(PARTIAL_FILTER_EXPRESSION_KEY));
                MongoPersistentEntity entity = this.type.map(val -> this.queryMapper.getMappingContext().getRequiredPersistentEntity((MongoPersistentProperty)((Object)val))).orElseGet(() -> this.lookupPersistentEntity(this.collectionName));
                ops = ops.partialFilterExpression(this.queryMapper.getMappedObject((Bson)((Object)indexOptions.get((Object)PARTIAL_FILTER_EXPRESSION_KEY, Document.class)), entity));
            }
            return collection.createIndex((Bson)indexDefinition.getIndexKeys(), ops);
        }).next();
    }

    @Nullable
    private MongoPersistentEntity<?> lookupPersistentEntity(String collection) {
        Collection<MongoPersistentEntity<?>> entities = this.queryMapper.getMappingContext().getPersistentEntities();
        return entities.stream().filter(entity -> entity.getCollection().equals(collection)).findFirst().orElse(null);
    }

    @Override
    public Mono<Void> dropIndex(String name) {
        return this.mongoOperations.execute(this.collectionName, collection -> collection.dropIndex(name)).then();
    }

    @Override
    public Mono<Void> dropAllIndexes() {
        return this.dropIndex("*");
    }

    @Override
    public Flux<IndexInfo> getIndexInfo() {
        return this.mongoOperations.execute(this.collectionName, collection -> collection.listIndexes(Document.class)).map(IndexConverters.documentToIndexInfoConverter()::convert);
    }
}

