/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.CountOperation;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class AggregationUtil {
    QueryMapper queryMapper;
    MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    AggregationOperationContext prepareAggregationContext(Aggregation aggregation, @Nullable AggregationOperationContext context) {
        if (context != null) {
            return context;
        }
        if (aggregation instanceof TypedAggregation) {
            return new TypeBasedAggregationOperationContext(((TypedAggregation)aggregation).getInputType(), this.mappingContext, this.queryMapper);
        }
        return Aggregation.DEFAULT_CONTEXT;
    }

    List<Document> createPipeline(Aggregation aggregation, AggregationOperationContext context) {
        if (!ObjectUtils.nullSafeEquals(context, Aggregation.DEFAULT_CONTEXT)) {
            return aggregation.toPipeline(context);
        }
        return this.mapAggregationPipeline(aggregation.toPipeline(context));
    }

    Document createCommand(String collection, Aggregation aggregation, AggregationOperationContext context) {
        Document command = aggregation.toDocument(collection, context);
        if (!ObjectUtils.nullSafeEquals(context, Aggregation.DEFAULT_CONTEXT)) {
            return command;
        }
        command.put("pipeline", (Object)this.mapAggregationPipeline((List)((Object)command.get((Object)"pipeline", List.class))));
        return command;
    }

    Aggregation createCountAggregation(Query query, @Nullable Class<?> entityClass) {
        List<AggregationOperation> pipeline = this.computeCountAggregationPipeline(query, entityClass);
        TypedAggregation<?> aggregation = entityClass != null ? Aggregation.newAggregation(entityClass, pipeline) : Aggregation.newAggregation(pipeline);
        ((Aggregation)aggregation).withOptions(AggregationOptions.builder().collation(query.getCollation().orElse(null)).build());
        return aggregation;
    }

    private List<AggregationOperation> computeCountAggregationPipeline(Query query, @Nullable Class<?> entityType) {
        CountOperation count = Aggregation.count().as("totalEntityCount");
        if (query.getQueryObject().isEmpty()) {
            return Collections.singletonList(count);
        }
        Assert.notNull(entityType, "Entity type must not be null!");
        final Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)entityType)));
        CriteriaDefinition criteria = new CriteriaDefinition(){

            @Override
            public Document getCriteriaObject() {
                return mappedQuery;
            }

            @Override
            @Nullable
            public String getKey() {
                return null;
            }
        };
        return Arrays.asList(Aggregation.match(criteria), count);
    }

    private List<Document> mapAggregationPipeline(List<Document> pipeline) {
        return pipeline.stream().map(val -> this.queryMapper.getMappedObject((Bson)val, Optional.empty())).collect(Collectors.toList());
    }

    public AggregationUtil(QueryMapper queryMapper, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.queryMapper = queryMapper;
        this.mappingContext = mappingContext;
    }
}

