/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import java.util.Optional;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.util.Assert;

@FunctionalInterface
public interface CodecRegistryProvider {
    public CodecRegistry getCodecRegistry();

    default public boolean hasCodecFor(Class<?> type) {
        return this.getCodecFor(type).isPresent();
    }

    default public <T> Optional<Codec<T>> getCodecFor(Class<T> type) {
        Assert.notNull(type, "Type must not be null!");
        try {
            return Optional.of(this.getCodecRegistry().get(type));
        }
        catch (CodecConfigurationException codecConfigurationException) {
            return Optional.empty();
        }
    }
}

