/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.msputility.dao;

import com.parablu.msputility.dao.MspDao;
import com.parablu.msputility.domain.InclusionFilter;
import com.parablu.msputility.domain.Pack;
import com.parablu.msputility.domain.Schedule;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class MspDaoImpl
implements MspDao {
    private static final String FILTER_NAME = "filterName";
    private static final String SCHEDULE_NAME = "scheduleName";
    private static final String SKU_CODE = "skuCode";
    @Autowired
    MongoTemplate mongoTemplate;

    public void insertInclusionFilter(InclusionFilter[] inclusionFilters) {
        System.out.println("Inserting inclusion filters");
        List existingFilterNames = this.mongoTemplate.findDistinct(FILTER_NAME, InclusionFilter.class, String.class);
        for (InclusionFilter inclusionFilter : inclusionFilters) {
            if (!existingFilterNames.contains(inclusionFilter.getFilterName())) {
                System.out.println("adding filter name = " + inclusionFilter.getFilterName());
                this.mongoTemplate.insert((Object)inclusionFilter);
                continue;
            }
            System.out.println("skipping as already exist filter name= " + inclusionFilter.getFilterName());
        }
        System.out.println("Inserted inclusion filters");
    }

    public void insertSchedule(Schedule[] schedules) {
        System.out.println("Inserting schedules");
        List existingScheduleNames = this.mongoTemplate.findDistinct(SCHEDULE_NAME, Schedule.class, String.class);
        for (Schedule schedule : schedules) {
            if (!existingScheduleNames.contains(schedule.getScheduleName())) {
                System.out.println("adding schedule name = " + schedule.getScheduleName());
                this.mongoTemplate.insert((Object)schedule);
                continue;
            }
            System.out.println("skipping as already exist schedule name = " + schedule.getScheduleName());
        }
        System.out.println("Inserted schedules");
    }

    public void insertPack(Pack[] packs) {
        System.out.println("Inserting packs");
        List existingPacksCode = this.mongoTemplate.findDistinct(SKU_CODE, Pack.class, String.class);
        for (Pack pack : packs) {
            if (!existingPacksCode.contains(pack.getSkuCode())) {
                System.out.println("adding sku code = " + pack.getSkuCode());
                this.mongoTemplate.insert((Object)pack);
                continue;
            }
            System.out.println("skipping as already exist sku code = " + pack.getSkuCode());
        }
        System.out.println("Inserted packs");
    }
}

