/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.CloudDNSExceptions;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.util.Predicates2;

public class JobPredicates {
    private JobPredicates() {
    }

    public static <T> T awaitComplete(CloudDNSApi api, Job<T> job) throws TimeoutException {
        AtomicReference jobRef = Atomics.newReference(job);
        if (!Predicates2.retry(JobPredicates.jobCompleted(api), (long)600L, (long)2L, (long)2L, (TimeUnit)TimeUnit.SECONDS).apply((Object)jobRef)) {
            throw new TimeoutException("Timeout on: " + jobRef.get());
        }
        return (T)((Job)jobRef.get()).getResource().orNull();
    }

    private static Predicate<AtomicReference<? extends Job<?>>> jobCompleted(CloudDNSApi cloudDNSApi) {
        return new JobStatusPredicate(cloudDNSApi, Job.Status.COMPLETED);
    }

    private static class JobStatusPredicate<T>
    implements Predicate<AtomicReference<Job<?>>> {
        private CloudDNSApi cloudDNSApi;
        private Job.Status status;

        private JobStatusPredicate(CloudDNSApi cloudDNSApi, Job.Status status) {
            this.cloudDNSApi = (CloudDNSApi)Preconditions.checkNotNull((Object)cloudDNSApi, (Object)"domainApi must be defined");
            this.status = (Job.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must be defined"));
        }

        public boolean apply(AtomicReference<Job<?>> jobRef) {
            Preconditions.checkNotNull(jobRef, (Object)"job must be defined");
            if (this.status.equals((Object)jobRef.get().getStatus())) {
                return true;
            }
            jobRef.set(this.cloudDNSApi.getJob(jobRef.get().getId()));
            Preconditions.checkNotNull(jobRef.get(), (String)"Job %s not found.", (Object)jobRef.get().getId());
            if (jobRef.get().getError().isPresent()) {
                throw new CloudDNSExceptions.JobErrorException((Job.Error)jobRef.get().getError().get());
            }
            return this.status.equals((Object)jobRef.get().getStatus());
        }
    }
}

