/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class ResourceRecord {
    private final String dName;
    private final int type;
    private final int ttl;
    private final List<String> infoValues;

    private ResourceRecord(String dName, int type, int ttl, List<String> infoValues) {
        this.dName = (String)Preconditions.checkNotNull((Object)dName, (Object)"dName");
        Preconditions.checkArgument((type >= 0 ? 1 : 0) != 0, (String)"type of %s must be >= 0", (Object)dName);
        this.type = type;
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0, (String)"ttl of %s must be >= 0", (Object)dName);
        this.ttl = ttl;
        this.infoValues = (List)Preconditions.checkNotNull(infoValues, (String)"infoValues of %s", (Object)dName);
    }

    public String getName() {
        return this.dName;
    }

    public int getType() {
        return this.type;
    }

    public int getTTL() {
        return this.ttl;
    }

    public List<String> getRData() {
        return this.infoValues;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dName, this.type, this.ttl, this.infoValues});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecord that = (ResourceRecord)ResourceRecord.class.cast(obj);
        return Objects.equal((Object)this.dName, (Object)that.dName) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal(this.infoValues, that.infoValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("dName", (Object)this.dName).add("type", this.type).add("ttl", this.ttl).add("infoValues", this.infoValues).toString();
    }

    public static Builder rrBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ResourceRecord.rrBuilder().from(this);
    }

    public static final class Builder {
        private String dName;
        private int type = -1;
        private int ttl = -1;
        private ImmutableList.Builder<String> infoValues = ImmutableList.builder();

        public Builder name(String dName) {
            this.dName = dName;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder infoValue(Object infoValue) {
            this.infoValues.add((Object)infoValue.toString());
            return this;
        }

        public Builder rdata(Object infoValue) {
            this.infoValues = ImmutableList.builder().add((Object)infoValue.toString());
            return this;
        }

        public Builder rdata(Iterable<?> infoValues) {
            this.infoValues = ImmutableList.builder().addAll(Iterables.transform(infoValues, (Function)Functions.toStringFunction()));
            return this;
        }

        public ResourceRecord build() {
            return new ResourceRecord(this.dName, this.type, this.ttl, (List)this.infoValues.build());
        }

        public Builder from(ResourceRecord in) {
            return this.name(in.getName()).type(in.getType()).ttl(in.getTTL()).rdata(in.getRData());
        }
    }
}

