/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebAssert;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyStore;

public class WebClientOptions
implements Serializable {
    private boolean javaScriptEnabled_ = true;
    private boolean cssEnabled_ = true;
    private boolean printContentOnFailingStatusCode_ = true;
    private boolean throwExceptionOnFailingStatusCode_ = true;
    private boolean throwExceptionOnScriptError_ = true;
    private boolean appletEnabled_;
    private boolean popupBlockerEnabled_;
    private boolean isRedirectEnabled_ = true;
    private KeyStore sslClientCertificateStore_;
    private char[] sslClientCertificatePassword_;
    private KeyStore sslTrustStore_;
    private String[] sslClientProtocols_;
    private String[] sslClientCipherSuites_;
    private boolean geolocationEnabled_;
    private boolean doNotTrackEnabled_;
    private boolean activeXNative_;
    private String homePage_ = "http://htmlunit.sf.net/";
    private ProxyConfig proxyConfig_;
    private int timeout_ = 90000;
    private boolean useInsecureSSL_;
    private String sslInsecureProtocol_;
    private int maxInMemory_ = 512000;
    private int historySizeLimit_ = 50;

    public void setUseInsecureSSL(boolean useInsecureSSL) {
        this.useInsecureSSL_ = useInsecureSSL;
    }

    public boolean isUseInsecureSSL() {
        return this.useInsecureSSL_;
    }

    public void setRedirectEnabled(boolean enabled) {
        this.isRedirectEnabled_ = enabled;
    }

    public boolean isRedirectEnabled() {
        return this.isRedirectEnabled_;
    }

    public void setSSLClientCertificate(InputStream certificateInputStream, String certificatePassword, String certificateType) {
        try {
            this.sslClientCertificateStore_ = WebClientOptions.getKeyStore(certificateInputStream, certificatePassword, certificateType);
            this.sslClientCertificatePassword_ = certificatePassword == null ? null : certificatePassword.toCharArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSSLClientCertificate(URL certificateUrl, String certificatePassword, String certificateType) {
        try (InputStream is = certificateUrl.openStream();){
            this.sslClientCertificateStore_ = WebClientOptions.getKeyStore(is, certificatePassword, certificateType);
            this.sslClientCertificatePassword_ = certificatePassword == null ? null : certificatePassword.toCharArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setSSLClientCertificateStore(KeyStore keyStore) {
        this.sslClientCertificateStore_ = keyStore;
    }

    public KeyStore getSSLClientCertificateStore() {
        return this.sslClientCertificateStore_;
    }

    public char[] getSSLClientCertificatePassword() {
        return this.sslClientCertificatePassword_;
    }

    public String[] getSSLClientProtocols() {
        return this.sslClientProtocols_;
    }

    public void setSSLClientProtocols(String[] sslClientProtocols) {
        this.sslClientProtocols_ = sslClientProtocols;
    }

    public String[] getSSLClientCipherSuites() {
        return this.sslClientCipherSuites_;
    }

    public void setSSLClientCipherSuites(String[] sslClientCipherSuites) {
        this.sslClientCipherSuites_ = sslClientCipherSuites;
    }

    public void setJavaScriptEnabled(boolean enabled) {
        this.javaScriptEnabled_ = enabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled_;
    }

    public void setCssEnabled(boolean enabled) {
        this.cssEnabled_ = enabled;
    }

    public boolean isCssEnabled() {
        return this.cssEnabled_;
    }

    public void setAppletEnabled(boolean enabled) {
        this.appletEnabled_ = enabled;
    }

    public boolean isAppletEnabled() {
        return this.appletEnabled_;
    }

    public void setPopupBlockerEnabled(boolean enabled) {
        this.popupBlockerEnabled_ = enabled;
    }

    public boolean isPopupBlockerEnabled() {
        return this.popupBlockerEnabled_;
    }

    public void setGeolocationEnabled(boolean enabled) {
        this.geolocationEnabled_ = enabled;
    }

    public boolean isGeolocationEnabled() {
        return this.geolocationEnabled_;
    }

    public void setDoNotTrackEnabled(boolean enabled) {
        this.doNotTrackEnabled_ = enabled;
    }

    public boolean isDoNotTrackEnabled() {
        return this.doNotTrackEnabled_;
    }

    public void setPrintContentOnFailingStatusCode(boolean enabled) {
        this.printContentOnFailingStatusCode_ = enabled;
    }

    public boolean getPrintContentOnFailingStatusCode() {
        return this.printContentOnFailingStatusCode_;
    }

    public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
        this.throwExceptionOnFailingStatusCode_ = enabled;
    }

    public boolean isThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public boolean isThrowExceptionOnScriptError() {
        return this.throwExceptionOnScriptError_;
    }

    public void setThrowExceptionOnScriptError(boolean enabled) {
        this.throwExceptionOnScriptError_ = enabled;
    }

    public void setActiveXNative(boolean allow) {
        this.activeXNative_ = allow;
    }

    public boolean isActiveXNative() {
        return this.activeXNative_;
    }

    public String getHomePage() {
        return this.homePage_;
    }

    public void setHomePage(String homePage) {
        this.homePage_ = homePage;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig_;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        WebAssert.notNull("proxyConfig", proxyConfig);
        this.proxyConfig_ = proxyConfig;
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public void setSSLInsecureProtocol(String sslInsecureProtocol) {
        this.sslInsecureProtocol_ = sslInsecureProtocol;
    }

    public String getSSLInsecureProtocol() {
        return this.sslInsecureProtocol_;
    }

    public void setSSLTrustStore(URL sslTrustStoreUrl, String sslTrustStorePassword, String sslTrustStoreType) {
        try (InputStream is = sslTrustStoreUrl.openStream();){
            this.sslTrustStore_ = WebClientOptions.getKeyStore(is, sslTrustStorePassword, sslTrustStoreType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setSSLTrustStore(KeyStore keyStore) {
        this.sslTrustStore_ = keyStore;
    }

    public KeyStore getSSLTrustStore() {
        return this.sslTrustStore_;
    }

    private static KeyStore getKeyStore(InputStream inputStream, String keystorePassword, String keystoreType) throws Exception {
        if (inputStream == null) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        char[] passwordChars = keystorePassword != null ? keystorePassword.toCharArray() : null;
        keyStore.load(inputStream, passwordChars);
        return keyStore;
    }

    public int getMaxInMemory() {
        return this.maxInMemory_;
    }

    public void setMaxInMemory(int maxInMemory) {
        this.maxInMemory_ = maxInMemory;
    }

    public int getHistorySizeLimit() {
        return this.historySizeLimit_;
    }

    public void setHistorySizeLimit(int historySizeLimit) {
        this.historySizeLimit_ = historySizeLimit;
    }
}

