/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors.autoreconf;

import com.thetransactioncompany.cors.CORSConfigurationException;
import com.thetransactioncompany.cors.CORSConfigurationLoader;
import com.thetransactioncompany.cors.CORSFilter;
import com.thetransactioncompany.cors.autoreconf.CORSConfigurationFileWatcher;
import com.thetransactioncompany.cors.autoreconf.CORSConfigurationWatcher;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class AutoReconfigurableCORSFilter
implements Filter {
    private static final Logger LOG = LogManager.getLogManager().getLogger("");
    private volatile CORSFilter filter;
    private volatile CORSConfigurationWatcher watcher;
    private CORSConfigurationLoader loader;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.loader = new CORSConfigurationLoader(filterConfig);
        this.watcher = new CORSConfigurationFileWatcher(filterConfig);
        this.watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CORSFilter getFilter() {
        if (!this.watcher.reloadRequired() && this.filter != null) return this.filter;
        Class<AutoReconfigurableCORSFilter> clazz = AutoReconfigurableCORSFilter.class;
        synchronized (AutoReconfigurableCORSFilter.class) {
            if (!this.watcher.reloadRequired() && this.filter != null) return this.filter;
            try {
                if (this.filter == null) {
                    LOG.info("CORS Filter: Initiated first configuration");
                } else {
                    LOG.info("CORS Filter: Initiated re-configuration");
                }
                CORSFilter oldFilter = this.filter;
                this.filter = new CORSFilter(this.loader.load());
                if (oldFilter != null) {
                    oldFilter.destroy();
                }
                this.watcher.reset();
            }
            catch (CORSConfigurationException e) {
                LOG.severe("CORS Filter: Failed to instantiate new CORS filter: " + e.getMessage());
            }
            return this.filter;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.getFilter().doFilter(request, response, chain);
    }

    public void destroy() {
        this.watcher.stop();
        if (this.filter != null) {
            this.filter.destroy();
        }
    }
}

