/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.ListLoadBalancersStrategy;
import org.jclouds.location.Region;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;

@Singleton
public class CloudLoadBalancersListLoadBalancersStrategy
implements ListLoadBalancersStrategy {
    private final CloudLoadBalancersApi aclient;
    private final Function<LoadBalancer, LoadBalancerMetadata> converter;
    private final Supplier<Set<String>> regions;

    @Inject
    protected CloudLoadBalancersListLoadBalancersStrategy(CloudLoadBalancersApi aclient, Function<LoadBalancer, LoadBalancerMetadata> converter, @Region Supplier<Set<String>> regions) {
        this.aclient = (CloudLoadBalancersApi)Preconditions.checkNotNull((Object)aclient, (Object)"aclient");
        this.regions = (Supplier)Preconditions.checkNotNull(regions, (Object)"regions");
        this.converter = (Function)Preconditions.checkNotNull(converter, (Object)"converter");
    }

    public Iterable<? extends LoadBalancerMetadata> listLoadBalancers() {
        ImmutableSet.Builder loadBalancers = ImmutableSet.builder();
        for (String region : (Set)this.regions.get()) {
            loadBalancers.addAll((Iterable)this.aclient.getLoadBalancerApi(region).list().concat().transform(this.converter));
        }
        return loadBalancers.build();
    }
}

