/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.v1.binders.BindMetadataToJsonPayload;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.UpdateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancers;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseMetadata;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@RequestFilters(value={AuthenticateRequest.class})
public interface LoadBalancerApi {
    @Named(value="lb:create")
    @POST
    @ResponseParser(value=ParseLoadBalancer.class)
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers")
    public LoadBalancer create(@WrapWith(value="loadBalancer") CreateLoadBalancer var1);

    @Named(value="lb:update")
    @PUT
    @ResponseParser(value=ParseLoadBalancer.class)
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers/{id}")
    public void update(@PathParam(value="id") int var1, @WrapWith(value="loadBalancer") UpdateLoadBalancer var2);

    @Named(value="lb:list")
    @GET
    @ResponseParser(value=ParseLoadBalancers.class)
    @Transform(value=ParseLoadBalancers.ToPagedIterable.class)
    @Consumes(value={"application/json"})
    @Path(value="/loadbalancers")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<LoadBalancer> list();

    @Named(value="lb:list")
    @GET
    @ResponseParser(value=ParseLoadBalancers.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/loadbalancers")
    public IterableWithMarker<LoadBalancer> list(PaginationOptions var1);

    @Named(value="lb:get")
    @GET
    @ResponseParser(value=ParseLoadBalancer.class)
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}")
    public LoadBalancer get(@PathParam(value="id") int var1);

    @Named(value="lb:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}")
    @Consumes(value={"*/*"})
    public void delete(@PathParam(value="id") int var1);

    @Named(value="lb:createmetadata")
    @POST
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseMetadata.class)
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/metadata")
    public Metadata createMetadata(@PathParam(value="id") int var1, @BinderParam(value=BindMetadataToJsonPayload.class) Map<String, String> var2);

    @Named(value="lb:getmetadata")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseMetadata.class)
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @Path(value="/loadbalancers/{id}/metadata")
    public Metadata getMetadata(@PathParam(value="id") int var1);

    @Named(value="lb:updatemetadatum")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Payload(value="%7B\"meta\":%7B\"value\":\"{value}\"%7D%7D")
    @Path(value="/loadbalancers/{id}/metadata/{metadatumId}")
    public boolean updateMetadatum(@PathParam(value="id") int var1, @PathParam(value="metadatumId") int var2, @PayloadParam(value="value") String var3);

    @Named(value="lb:deletemetadatum")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @Path(value="/loadbalancers/{id}/metadata/{metadatumId}")
    public boolean deleteMetadatum(@PathParam(value="id") int var1, @PathParam(value="metadatumId") int var2);

    @Named(value="lb:deletemetadata")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @Path(value="/loadbalancers/{id}/metadata")
    public boolean deleteMetadata(@PathParam(value="id") int var1, @QueryParam(value="id") Iterable<Integer> var2);
}

