/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class BaseNode<T extends BaseNode<T>>
implements Comparable<BaseNode<T>> {
    protected String address;
    protected int port;
    protected Condition condition;
    protected Type type;
    protected Integer weight;

    protected BaseNode() {
    }

    public BaseNode(String address, int port, Condition condition, Type type, Integer weight) {
        this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
        Preconditions.checkArgument((port != -1 ? 1 : 0) != 0, (Object)"port must be specified");
        this.port = port;
        this.condition = (Condition)((Object)Preconditions.checkNotNull((Object)((Object)condition), (Object)"condition"));
        this.type = type;
        this.weight = weight;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(BaseNode<T> arg0) {
        return this.address.compareTo(arg0.address);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("address", (Object)this.address).add("port", this.port).add("condition", (Object)this.condition).add("type", (Object)this.type).add("weight", (Object)this.weight);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address, this.port, this.condition});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseNode that = (BaseNode)BaseNode.class.cast(obj);
        return Objects.equal((Object)this.address, (Object)that.address) && Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)((Object)this.condition), (Object)((Object)that.condition));
    }

    public static <T extends BaseNode<T>> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<BaseNode>().from(this);
    }

    public static class Builder<T extends BaseNode<T>> {
        protected String address;
        protected int port = -1;
        protected Condition condition = Condition.ENABLED;
        protected Type type;
        protected Integer weight;

        public Builder<T> address(String address) {
            this.address = address;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder<T> type(Type type) {
            this.type = type;
            return this;
        }

        public Builder<T> weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public BaseNode<T> build() {
            return new BaseNode(this.address, this.port, this.condition, this.type, this.weight);
        }

        public Builder<T> from(T in) {
            return this.address(((BaseNode)in).getAddress()).port(((BaseNode)in).getPort()).condition(((BaseNode)in).getCondition()).type(((BaseNode)in).getType()).weight(((BaseNode)in).getWeight());
        }
    }

    public static enum Type {
        PRIMARY,
        SECONDARY,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Condition {
        ENABLED,
        DISABLED,
        DRAINING,
        UNRECOGNIZED;


        public static Condition fromValue(String condition) {
            try {
                return Condition.valueOf((String)Preconditions.checkNotNull((Object)condition, (Object)"condition"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

