#!/bin/bash
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: VAIBHAV K                                                                                      #
# PLATFORM: Ubuntu

PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

enablesite_conf="/etc/apache2/sites-enabled/default-ssl.conf"

sed -i '/ServerName/d' $enablesite_conf
sed -i "/ServerAdmin support@parablu.com/a ServerName $BLUVAULT_IP" $enablesite_conf

service apache2 restart

sudo apt-get update
sudo apt-get install software-properties-common
sudo add-apt-repository universe
sudo add-apt-repository ppa:certbot/certbot
sudo apt-get update
apt-get -f install
sudo apt-get install certbot python-certbot-apache

sleep 10s
tput clear
echo "Configuring Lets Encrypt"
sudo certbot --apache


sleep 5s
service apache2 restart

croncmd="sudo certbot renew --dry-run 2>&1 && /etc/init.d/apache2 restart"
cronjob="0 0 1 * * $croncmd"
( crontab -l | grep -v -F "$croncmd" ; echo "$cronjob" ) | crontab -
