#!/bin/bash
#                                                                                       #
# SCRIPT: install_primary_monmgo.sh                                                             #
# DATE:   01-September-2017                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems                                                         #
# DEVELOPER: Vaibhav K
# PURPOSE: Common Script for preserving manual changes in properties files                    #
# PLATFORM: Ubuntu


function custom_property_change ()
{
	while read -r line;
	do
		case $line in
       			''|\#*) continue ;;         ## skip blank lines and lines starting with ##
   		esac
        	vals=`echo -e "$line\n"`;
        	new_val=$(echo "$vals" | sed -e 's/=.*//')
        	if [ "`grep -F "$new_val" $PATH_NEW | wc -l`" -gt 0 ]; then
			sed -i "/^$new_val=/d" $PATH_NEW
	                echo "$vals" >> $PATH_NEW
        	fi
       	done < $PATH_OLD
}

function custom_log4j_changes ()
{

        while read -r line;
        do
                case $line in
                        ''|\#*) continue ;;         ## skip blank lines and lines starting with ##
                esac
                vals=`echo -e "$line\n"`;
                new_val=$(echo "$vals" | sed -e 's/=.*//')
                if [ "`grep -F "$new_val=" $PATH_NEW | wc -l`" -gt 0 ]; then
                        sed -i "s|"$new_val=".*|$vals|" $PATH_NEW
                fi
        done < $PATH_OLD
}
