#!/bin/bash
#Developed By: Vaibhav K
# Script: BACKBLAZE AUTOMATION
# DATE: 18 FEB 2020

PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=../../config/parablu_component_config.sh

source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH

BACKBLAZE_ID="000b8da189f151b0000000001"
APPLICATION_KEY="K000+opcbeMwqmmpWRDJztjdR6+5CmY"
BACKBLAZE_BUCKET="CUST-Mongodbbackup"
export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"
PULLLOGS_CHECK_FILE="get_logs"
dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
INPUT_FOLDER='INPUT'


function get_cust_name ()
{
#        custname=$(grep "CUSTOMER_NAME=" /var/lib/parablusys/bin/scripts/mongo_full_backup.sh)
 #       CUSTOMER_NAME=$(echo $custname | tr -d ' ' | sed -e 's/CUSTOMER_NAME=//' | sed 's/"//g')

	echo 'use parablu001

db.MONGO_PROPERTIES.find({}).forEach(function(e){print("P_CUSTNAME=" +e.customer_name)})' >plog_mongoproperties.js

	cp plog_mongoproperties.js plog_mongoproperties_install.js
	sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < plog_mongoproperties_install.js > plog_mongo_properties

	CUSTOMER_NAME_VAL=$(grep "P_CUSTNAME" plog_mongo_properties | sed -e 's/P_CUSTNAME=//')

	if [ "$CUSTOMER_NAME_VAL" == "undefined" ]; then

                CUSTOMER_NAME=$CLOUD_NAME

        elif [ ! -z "$CUSTOMER_NAME_VAL" ]; then

                CUSTOMER_NAME=$CUSTOMER_NAME_VAL

        else

                CUSTOMER_NAME=$CLOUD_NAME

        fi

}

function get_ip_list ()
{

if [ "$SERVER_TYPE" == "3 1" ]; then

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName");' >ipplist.js
else

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >ipplist.js
fi

        sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < ipplist.js >ipplist.log

        grep '"' ipplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_ipplist.log
	sed -i "/Implicit/d" sorted_iplist.log
        final_iplist=`cat sorted_ipplist.log`
        OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}

function otherServer_scriptUtil ()
{

get_ip_list
for ping_ip in ${OTHER_WATCHDOG_IP[@]}
        do
		scp -r -P $SSH_PORT ExecuteScriptUtil.zip $SSH_USERNAME@$ping_ip:.
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "unzip -o ExecuteScriptUtil.zip && bash ExecuteScriptUtil.sh"
		sleep 2s

		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "zip -r $ping_ip-utiloutput.zip scriptutil.log" 2> /dev/null
		sleep 2s

		scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:$ping_ip-utiloutput.zip . 2> /dev/null
		sleep 5s
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf $ping_ip-utiloutput.zip ExecuteScriptUtil.zip ExecuteScriptUtil.sh scriptutil.log scriptutil.log" 2> /dev/null
	done

}

function getOtherServerLogs ()
{

get_ip_list
for ping_ip in ${OTHER_WATCHDOG_IP[@]}
        do
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "zip -r $ping_ip-allLog.zip /parablu/log/"
		sleep 2s
		scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:$ping_ip-allLog.zip .
		sleep 2s
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf $ping_ip-allLog.zip"
	done

}

function get_logs ()
{
get_cust_name

	c_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs -e ExecuteScriptUtil.zip -e GetAgentRequest.txt  -e PullAgentRequest.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt`
	echo ""
	echo "RUNNING SERVER LOG REQUEST..."
	if [ -z $c_folders ];  then

                echo "NO NEW SERVER LOG REQUEST"
        fi
	for pl in ${c_folders[@]}
        do
		backblaze-b2 ls $BACKBLAZE_BUCKET $pl | grep -oh $PULLLOGS_CHECK_FILE
		if [ $? -eq 0 ]; then
			date_time=`date +%F_%T`
			#success_folder=$(echo $pl | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pl | sed 's/.*INPUT//' | sed 's/\///g')

			echo "SERVER LOG REQUEST FOUND IN: $pl"

			GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pl  | grep -v -e .bzEmpty | grep $PULLLOGS_CHECK_FILE | awk '{print $1}' | head -1`
			#echo "FILE VERSION: $GET_FILE_VERSION"
			sleep 1s

			zip -r `hostname`-allLog.zip /var/lib/tomcat-pcb1/logs
			zip -r `hostname`-allLog.zip /var/lib/tomcat-job1/logs
			zip -r `hostname`-allLog.zip /parablu/log/
			echo "RESPONSE CODE IS:$?" > response.log

			sleep 1s

			zip -r `hostname`-allLog.zip response.log

			sleep 2s
			rm response.log

			if [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
				getOtherServerLogs
			fi

			sleep 1s
			zip -r allLogs.zip *.zip
			sleep 2s

			#backblaze-b2 upload-file  $BACKBLAZE_BUCKET allLogs.zip $pl\allLogs_$date_time.zip
			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allLogs.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-allLogs_$date_time.zip

			backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

			GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pl | grep bzEmpty | awk '{print $1}' | head -1`
			if [ ! -z $GET_LASTFILE_VERSION ]; then
				backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
			fi	

			sleep 4s

			rm -rf *.zip
#			sleep 10s

		else
			echo "NO NEW SERVER LOG REQUEST FOUND IN: $pl"
		fi
	done
}	


function check_utilscript_backblaze ()
{
	get_cust_name
#	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

	p_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs -e ExecuteScriptUtil.zip -e GetAgentRequest.txt  -e PullAgentRequest.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt`

	echo ""
	echo "RUNNING SCRIPT GENERAL PURPOSE UTILITY...."
	if [ -z $p_folders ];  then

                echo "NO NEW SCRIPT UTILS"
        fi
	for pf in ${p_folders[@]}
        do
	date_time=`date +%F_%T`	
        backblaze-b2 ls $BACKBLAZE_BUCKET $pf | grep -oh ExecuteScriptUtil.zip
	
	if [ $? -eq 0 ]; then
		echo "NEW SCRIPT UTILS FOUND IN $pf"
		GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf  | grep ExecuteScriptUtil.zip | awk '{print $1}' | head -1`
		#echo "FILE VERSION: $GET_FILE_VERSION"
		sleep 1s

		backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $pf\ExecuteScriptUtil.zip ExecuteScriptUtil.zip
		if [ $? -eq 0 ]; then
			echo "FILE DOWNLOADED SUCCESSFULLY"
			#success_folder=$(echo $pf | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pf | sed 's/.*INPUT//' | sed 's/\///g')

			unzip -o ExecuteScriptUtil.zip

			sleep 2s

			bash ExecuteScriptUtil.sh

			sleep 5s
		
			zip -r `hostname`-utiloutput.zip scriptutil.log
			if [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
				otherServer_scriptUtil
			fi
		
			sleep 1s

#			rm ExecuteScriptUtil.zip
			sleep 2s
			zip -r allUtiloutput.zip *.zip
			sleep 2s

#			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $pf\DONE/allUtiloutput-$date_time.zip
			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-allUtiloutput-$date_time.zip

			backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

			sleep 1s
			GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf | grep bzEmpty | awk '{print $1}' | head -1`
			if [ ! -z $GET_LASTFILE_VERSION ]; then
	                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
			fi	

			sleep 4s

			rm -rf *.zip
			rm ExecuteScriptUtil.sh

			rm scriptutil.log
			sleep 3s
		else
			echo "UNABLE TO DOWNLOAD FILE"
		fi
	else
		echo "NO NEW SCRIPT UTILS FOUND in $pf"

	fi
done	

}

function check_valid_request ()
{

	get_cust_name
	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	get_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs.txt -e ExecuteScriptUtil.zip -e ChangeCloudValidity.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e GetAgentRequest.txt  -e PullAgentRequest.txt`
	echo "CHECKING FOR INVALID REQUESTS.................."
	echo ""
        for gf in ${get_folders[@]}
        do

                backblaze-b2 ls $BACKBLAZE_BUCKET $gf | grep -v -e bzEmpty -e get_logs.txt -e ExecuteScriptUtil.zip -e ChangeCloudValidity.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e GetAgentRequest.txt  -e PullAgentRequest.txt &>/dev/null
                if [ $? -eq 0 ]; then
                        GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $gf  | grep -v -e bzEmpty -e get_logs.txt -e ExecuteScriptUtil.zip -e ChangeCloudValidity.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e GetAgentRequest.txt  -e PullAgentRequest.txt | awk '{print $1}' | head -1`
                        GET_FILENAME=`backblaze-b2 ls  $BACKBLAZE_BUCKET $gf  | grep -v -e bzEmpty -e get_logs.txt -e ExecuteScriptUtil.zip -e ChangeCloudValidity.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e GetAgentRequest.txt  -e PullAgentRequest.txt`
                        DOW_UPL_FILENAME="${GET_FILENAME##*/}"
                        if [[ ! -z $DOW_UPL_FILENAME ]]; then
                                #success_folder=$(echo $gf | sed 's/[^/]*//' | sed 's/\///g')
				success_folder=$(echo $gf | sed 's/.*INPUT//' | sed 's/\///g')

				echo "INVALID REQUEST FOUND IN FOLDER: [ $gf ]"
                                echo "MOVING INVALID REQUEST [ $GET_FILENAME ] TO ERROR FOLDER........."
                                backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $GET_FILENAME $DOW_UPL_FILENAME &>/dev/null
                                sleep 2s
                                backblaze-b2 upload-file  $BACKBLAZE_BUCKET $DOW_UPL_FILENAME $CUSTOMER_NAME/ERROR/$success_folder/ERRINPUT_$DOW_UPL_FILENAME &>/dev/null
                                sleep 2s
                                backblaze-b2 delete-file-version $GET_FILE_VERSION &>/dev/null

				sleep 2s
				GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $gf | grep bzEmpty | awk '{print $1}' | head -1`
                       		if [ ! -z $GET_LASTFILE_VERSION ]; then
                              		backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
                        	fi

				rm $DOW_UPL_FILENAME

                       fi
                else
                        echo "VALID REQUEST FOUND IN: $gf" &>/dev/null
                fi



        done


}	

function pullagent_backblaze ()
{
        get_cust_name
 #       backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

        p_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs.txt -e ExecuteScriptUtil.zip -e GetAgentRequest.txt  -e PullAgentRequest.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt`
	echo ""
	echo "RUNNING PULL AGENT LOG REQUEST..."
	if [ -z $p_folders ];  then

                echo "NO NEW AGENT PULL REQUEST"
        fi
	sleep 2s
        for pf in ${p_folders[@]}
        do
        date_time=`date +%F_%T`
        backblaze-b2 ls $BACKBLAZE_BUCKET $pf | grep -oh PullAgentRequest.txt

        if [ $? -eq 0 ]; then
                echo "NEW PULL REQUEST FOUND IN : [ $pf ]"
                GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf  | grep PullAgentRequest.txt | awk '{print $1}' | head -1`
                echo "FILE VERSION: $GET_FILE_VERSION"
                sleep 1s

                backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $pf\PullAgentRequest.txt PullAgentRequest.txt
                if [ $? -eq 0 ]; then
                        echo "FILE DOWNLOADED SUCCESSFULLY"
			sleep 2s
                        #success_folder=$(echo $pf | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pf | sed 's/.*INPUT//' | sed 's/\///g')

                        #unzip -o PullAgentRequest.zip

                        sleep 2s

                        bash PullAgentRequest.sh

                        sleep 5s

                        zip -r PullAgent-output.zip pullrequest.log PullAgentRequest.txt
                        sleep 2s

#                       backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $pf\DONE/allUtiloutput-$date_time.zip
                        backblaze-b2 upload-file  $BACKBLAZE_BUCKET PullAgent-output.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-PullAgent-output-$date_time.zip

                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION
			sleep 1s

			GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf | grep bzEmpty | awk '{print $1}' | head -1`
			if [ ! -z $GET_LASTFILE_VERSION ]; then
                  	      backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
			fi

                        sleep 4s

                        rm -rf *.zip
                        rm PullAgentRequest.txt

                        rm pullrequest.log
                        sleep 3s
                else
                        echo "UNABLE TO DOWNLOAD FILE"
                fi
        else
                echo "NO NEW AGENT PULL REQUEST in [ $pf ]"

        fi
done

}

function getagent_backblaze ()
{
        get_cust_name
  #      backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

        p_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs -e ExecuteScriptUtil.zip -e GetAgentRequest.txt  -e PullAgentRequest.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt`
	echo ""
	echo "RUNNING GET AGENT LOG REQUEST....."

	if [ -z $p_folders ];  then

		echo "NO NEW GET AGENT REQUEST"
	fi	
	sleep 2s
        for pf in ${p_folders[@]}
        do
        date_time=`date +%F_%T`
        backblaze-b2 ls $BACKBLAZE_BUCKET $pf | grep -oh GetAgentRequest.txt

        if [ $? -eq 0 ]; then
                echo "GET REQUEST FOUND IN $pf"
		sleep 2s
                GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf  | grep GetAgentRequest.txt | awk '{print $1}' | head -1`
                echo "FILE VERSION: $GET_FILE_VERSION"
                sleep 1s

                backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $pf\GetAgentRequest.txt GetAgentRequest.txt
                if [ $? -eq 0 ]; then
                        echo "FILE DOWNLOADED SUCCESSFULLY"
			sleep 2s
                        #success_folder=$(echo $pf | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pf | sed 's/.*INPUT//' | sed 's/\///g')

#                        unzip -o GetAgentRequest.zip

                        sleep 2s

                        bash GetAgentRequest.sh

                        sleep 5s

			grep "reason=success" getrequest.log
			if [ $? -eq 0 ]; then

				zip -r GetAgent-output.zip Agentlogs.zip 

			fi				

                        zip -r GetAgent-output.zip getrequest.log GetAgentRequest.txt
                        sleep 2s

#                       backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $pf\DONE/allUtiloutput-$date_time.zip
                        backblaze-b2 upload-file  $BACKBLAZE_BUCKET GetAgent-output.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-GetAgent-output-$date_time.zip

                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

			sleep 1s

			GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf | grep bzEmpty | awk '{print $1}' | head -1`
			if [ ! -z $GET_LASTFILE_VERSION ]; then
	                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
			fi	

                        sleep 4s

                        rm -rf *.zip
                        rm GetAgentRequest.txt

                        rm getrequest.log
                        sleep 3s
                else
                        echo "UNABLE TO DOWNLOAD FILE"
                fi
        else
                echo "NO NEW GET AGENT Request in $pf"

        fi
done

}

### CHANGING LICENCE VALIDITY
function check_cloudvalidity_backblaze ()
{
	get_cust_name
#	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

	p_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs.txt -e ExecuteScriptUtil.zip -e PullAgentRequest.txt -e GetAgentRequest.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt`

	echo ""
	echo "RUNNING SCRIPT UTILS FOR CLOUD VALIDITY...."
	if [ -z $p_folders ];  then

                echo "NO NEW SCRIPT UTILS FOUND FOR CLOUD VALIDITY"
        fi
	for pf in ${p_folders[@]}
        do
	date_time=`date +%F_%T`
        backblaze-b2 ls $BACKBLAZE_BUCKET $pf | grep -oh ChangeCloudValidity.txt

	if [ $? -eq 0 ]; then
		echo "NEW CLOUD VALIDITY SCRIPT UTILS FOUND IN $pf"
		GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf  | grep ChangeCloudValidity.txt | awk '{print $1}' | head -1`
		#echo "FILE VERSION: $GET_FILE_VERSION"
		sleep 1s

		backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $pf\ChangeCloudValidity.txt ChangeCloudValidity.txt
		if [ $? -eq 0 ]; then
			echo "FILE DOWNLOADED SUCCESSFULLY"
			#success_folder=$(echo $pf | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pf | sed 's/.*INPUT//' | sed 's/\///g')


			sleep 2s

			bash ChangeCloudValidity.sh

			sleep 5s

			zip -r `hostname`-utiloutput.zip scriptutil.log

			sleep 2s
			zip -r allUtiloutput.zip *.zip ChangeCloudValidity.txt
			sleep 2s

			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-allUtiloutput-$date_time.zip

			backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

			sleep 1s
			GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf | grep bzEmpty | awk '{print $1}' | head -1`
			if [ ! -z $GET_LASTFILE_VERSION ]; then
	                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
			fi

			sleep 4s

			rm -rf *.zip
			rm ChangeCloudValidity.txt

			rm scriptutil.log
			sleep 3s
		else
			echo "UNABLE TO DOWNLOAD FILE"
		fi
	else
		echo "NO NEW CLOUD VALIDITY SCRIPT UTILS FOUND in $pf"

	fi
done

}

#### CHECKING INCOMING THREAD
function check_incomingthread_backblaze ()
{
	get_cust_name
#	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

	p_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs.txt -e ExecuteScriptUtil.zip -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt -e GetAgentRequest.txt  -e PullAgentRequest.txt`

	echo ""
	echo "RUNNING SCRIPT UTILS FOR INCOMING THREAD CHANGE...."
	if [ -z $p_folders ];  then

                echo "NO NEW SCRIPT UTILS FOUND FOR INCOMING THREAD CHANGE"
        fi
	for pf in ${p_folders[@]}
        do
	date_time=`date +%F_%T`
        backblaze-b2 ls $BACKBLAZE_BUCKET $pf | grep -oh ChangeIncoming.txt

	if [ $? -eq 0 ]; then
		echo "NEW SCRIPT UTILS FOUND FOR INCOMING THREAD CHANGE IN $pf"
		GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf  | grep ChangeIncoming.txt | awk '{print $1}' | head -1`
		#echo "FILE VERSION: $GET_FILE_VERSION"
		sleep 1s

		backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $pf\ChangeIncoming.txt ChangeIncoming.txt
		if [ $? -eq 0 ]; then
			echo "FILE DOWNLOADED SUCCESSFULLY"
			#success_folder=$(echo $pf | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pf | sed 's/.*INPUT//' | sed 's/\///g')


			sleep 2s

			bash ChangeIncoming.sh

			sleep 5s

			zip -r `hostname`-utiloutput.zip scriptutil.log

			sleep 2s
			zip -r allUtiloutput.zip *.zip ChangeIncoming.txt
			sleep 2s

#			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $pf\DONE/allUtiloutput-$date_time.zip
			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-allUtiloutput-$date_time.zip

			backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

			sleep 1s
			GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf | grep bzEmpty | awk '{print $1}' | head -1`
			if [ ! -z $GET_LASTFILE_VERSION ]; then
	                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
			fi

			sleep 4s

			rm -rf *.zip
			rm ChangeIncoming.txt

			rm scriptutil.log
			sleep 3s
		else
			echo "UNABLE TO DOWNLOAD FILE"
		fi
	else
		echo "NO NEW SCRIPT UTILS FOUND FOR INCOMING THREAD CHANGE in $pf"

	fi
done

}

##### OUTGOING THREAD CHANGE
function check_outgoingthread_backblaze ()
{
        get_cust_name
#       backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY

        p_folders=`backblaze-b2 ls CUST-Mongodbbackup $CUSTOMER_NAME/$INPUT_FOLDER | grep -v -e bzEmpty -e PROCESSED -e ERROR -e .gpg -e get_logs.txt -e ExecuteScriptUtil.zip -e ChangeCloudValidity.txt -e ChangeIncoming.txt -e ChangeOutgoing.txt -e ChangeCloudValidity.txt -e GetAgentRequest.txt  -e PullAgentRequest.txt`

        echo ""
        echo "RUNNING SCRIPT UTILS FOR OUTGOING THREAD CHANGE...."
        if [ -z $p_folders ];  then

                echo "NO NEW SCRIPT UTILS FOUND FOR OUTGOING THREAD CHANGE"
        fi
        for pf in ${p_folders[@]}
        do
        date_time=`date +%F_%T`
        backblaze-b2 ls $BACKBLAZE_BUCKET $pf | grep -oh ChangeOutgoing.txt

        if [ $? -eq 0 ]; then
                echo "NEW SCRIPT UTILS FOUND FOR OUTGOING THREAD CHANGE IN $pf"
                GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf  | grep ChangeOutgoing.txt | awk '{print $1}' | head -1`
                #echo "FILE VERSION: $GET_FILE_VERSION"
                sleep 1s

                backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $pf\ChangeOutgoing.txt ChangeOutgoing.txt
                if [ $? -eq 0 ]; then
                        echo "FILE DOWNLOADED SUCCESSFULLY"
                        #success_folder=$(echo $pf | sed 's/[^/]*//' | sed 's/\///g')
			success_folder=$(echo $pf | sed 's/.*INPUT//' | sed 's/\///g')


                        sleep 2s

                        bash ChangeOutgoing.sh

                        sleep 5s

                        zip -r `hostname`-utiloutput.zip scriptutil.log

			sleep 2s
                        zip -r allUtiloutput.zip *.zip ChangeOutgoing.txt
                        sleep 2s

#                       backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $pf\DONE/allUtiloutput-$date_time.zip
                        backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $CUSTOMER_NAME/PROCESSED/$success_folder/$success_folder-allUtiloutput-$date_time.zip

                        backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

                        sleep 1s
                        GET_LASTFILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $pf | grep bzEmpty | awk '{print $1}' | head -1`
                        if [ ! -z $GET_LASTFILE_VERSION ]; then
                                backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_LASTFILE_VERSION
                        fi

                        sleep 4s

                        rm -rf *.zip
                        rm ChangeOutgoing.txt

                        rm scriptutil.log
                        sleep 3s
                else
                        echo "UNABLE TO DOWNLOAD FILE"
                fi
        else
                echo "NO NEW SCRIPT UTILS FOUND FOR OUTGOING THREAD CHANGE in $pf"

        fi
done

}


check_valid_request
sleep 5s
get_logs
sleep 10
check_utilscript_backblaze
pullagent_backblaze
getagent_backblaze
check_cloudvalidity_backblaze
check_outgoingthread_backblaze
check_incomingthread_backblaze
