/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query.validation;

import java.util.List;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.validation.OperationValidator;
import org.mongodb.morphia.query.validation.ValidationFailure;

public final class ExistsOperationValidator
extends OperationValidator {
    private static final ExistsOperationValidator INSTANCE = new ExistsOperationValidator();

    private ExistsOperationValidator() {
    }

    public static ExistsOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.EXISTS;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value.getClass() != Boolean.class) {
            validationFailures.add(new ValidationFailure(String.format("For an $exists operation, value '%s' should be a boolean type.  Instead it was a: %s", value, value.getClass())));
        }
    }
}

