/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.classrules;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Transient;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ClassConstraint;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.utils.ReflectionUtils;

public class ContainsEmbeddedWithId
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, MappedClass mc, Set<ConstraintViolation> ve) {
        HashSet classesToInspect = new HashSet();
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(mc.getClazz(), true)) {
            if (!this.isFieldToInspect(field) || field.isAnnotationPresent(Id.class)) continue;
            classesToInspect.add(field.getType());
        }
        this.checkRecursivelyHasNoIdAnnotationPresent(classesToInspect, new HashSet(), mc, ve);
    }

    private void checkRecursivelyHasNoIdAnnotationPresent(Set<Class<?>> classesToInspect, HashSet<Class<?>> alreadyInspectedClasses, MappedClass mc, Set<ConstraintViolation> ve) {
        for (Class<?> clazz : classesToInspect) {
            if (alreadyInspectedClasses.contains(clazz)) continue;
            if (this.hasTypeFieldAnnotation(clazz, Id.class)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, this.getClass(), "You cannot use @Id on any field of an Embedded/Property object"));
            }
            alreadyInspectedClasses.add(clazz);
            HashSet extraClassesToInspect = new HashSet();
            for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(clazz, true)) {
                if (!this.isFieldToInspect(field)) continue;
                extraClassesToInspect.add(field.getType());
            }
            this.checkRecursivelyHasNoIdAnnotationPresent(extraClassesToInspect, alreadyInspectedClasses, mc, ve);
        }
    }

    private boolean hasTypeFieldAnnotation(Class<?> type, Class<Id> class1) {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(type, true)) {
            if (field.getAnnotation(class1) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isFieldToInspect(Field field) {
        return !field.isAnnotationPresent(Transient.class) && !field.isAnnotationPresent(Reference.class) && !Modifier.isTransient(field.getModifiers());
    }
}

