/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.lazy;

import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.lazy.LazyProxyFactory;

public final class LazyFeatureDependencies {
    private static final Logger LOG = MorphiaLoggerFactory.get(LazyFeatureDependencies.class);
    private static Boolean fulFilled;

    private LazyFeatureDependencies() {
    }

    public static boolean assertDependencyFullFilled() {
        boolean fulfilled = LazyFeatureDependencies.testDependencyFullFilled();
        if (!fulfilled) {
            LOG.warning("Lazy loading impossible due to missing dependencies.");
        }
        return fulfilled;
    }

    public static boolean testDependencyFullFilled() {
        if (fulFilled != null) {
            return fulFilled;
        }
        try {
            fulFilled = Class.forName("net.sf.cglib.proxy.Enhancer") != null && Class.forName("com.thoughtworks.proxy.toys.hotswap.HotSwapping") != null;
        }
        catch (ClassNotFoundException e) {
            fulFilled = false;
        }
        return fulFilled;
    }

    public static LazyProxyFactory createDefaultProxyFactory() {
        if (LazyFeatureDependencies.testDependencyFullFilled()) {
            String factoryClassName = "org.mongodb.morphia.mapping.lazy.CGLibLazyProxyFactory";
            try {
                return (LazyProxyFactory)Class.forName("org.mongodb.morphia.mapping.lazy.CGLibLazyProxyFactory").newInstance();
            }
            catch (Exception e) {
                LOG.error("While instantiating org.mongodb.morphia.mapping.lazy.CGLibLazyProxyFactory", e);
            }
        }
        return null;
    }
}

