/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping;

import com.mongodb.DBObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.utils.ReflectionUtils;

public class EphemeralMappedField
extends MappedField {
    private ParameterizedType pType;
    private Object value;
    private MappedField parent;

    public EphemeralMappedField(ParameterizedType t, MappedField mf, Mapper mapper) {
        super(mf.getField(), t, mapper);
        this.parent = mf;
        this.pType = t;
        Class rawClass = (Class)t.getRawType();
        this.setIsSet(ReflectionUtils.implementsInterface(rawClass, Set.class));
        this.setIsMap(ReflectionUtils.implementsInterface(rawClass, Map.class));
        this.setMapKeyType(this.getMapKeyClass());
        this.setSubType(this.getSubType());
        this.setIsMongoType(ReflectionUtils.isPropertyType(this.getSubClass()));
    }

    public EphemeralMappedField(Type t, MappedField mf, Mapper mapper) {
        super(mf.getField(), t, mapper);
        this.parent = mf;
    }

    @Override
    public void addAnnotation(Class<? extends Annotation> clazz) {
    }

    @Override
    public void addAnnotation(Class<? extends Annotation> clazz, Annotation ann) {
    }

    @Override
    public Object getDbObjectValue(DBObject dbObj) {
        return dbObj;
    }

    @Override
    public Object getFieldValue(Object instance) {
        return this.value;
    }

    @Override
    public Class getMapKeyClass() {
        return (Class)(this.isMap() ? this.pType.getActualTypeArguments()[0] : null);
    }

    @Override
    public String getNameToStore() {
        return "superFake";
    }

    @Override
    public Class getSubClass() {
        return this.toClass(this.getSubType());
    }

    @Override
    public Type getSubType() {
        return this.pType != null ? this.pType.getActualTypeArguments()[this.isMap() ? 1 : 0] : null;
    }

    @Override
    public Class getType() {
        if (this.pType == null) {
            return super.getType();
        }
        if (this.isMap()) {
            return Map.class;
        }
        return List.class;
    }

    @Override
    public boolean hasAnnotation(Class ann) {
        return Embedded.class.equals((Object)ann);
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }

    @Override
    public void setFieldValue(Object instance, Object val) {
        this.value = val;
    }

    @Override
    public String toString() {
        return "EphemeralMappedField for " + super.toString();
    }

    @Override
    protected String getMappedFieldName() {
        return "";
    }

    public MappedField getParent() {
        return this.parent;
    }

    public Object getValue() {
        return this.value;
    }
}

