/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import java.util.List;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.utils.ReflectionUtils;

public class IntegerConverter
extends TypeConverter
implements SimpleValueConverter {
    public IntegerConverter() {
        super(Integer.TYPE, Integer.class, int[].class, Integer[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)val);
        }
        return Integer.parseInt(val.toString());
    }
}

