/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.MappingException;

public class CharacterConverter
extends TypeConverter
implements SimpleValueConverter {
    public CharacterConverter() {
        super(Character.TYPE, Character.class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        if (fromDBObject instanceof String) {
            char[] chars = ((String)fromDBObject).toCharArray();
            if (chars.length == 1) {
                return Character.valueOf(chars[0]);
            }
            if (chars.length == 0) {
                return Character.valueOf('\u0000');
            }
        }
        throw new MappingException("Trying to map multi-character data to a single character: " + fromDBObject);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        return value == null || value.equals(Character.valueOf('\u0000')) ? null : String.valueOf(value);
    }
}

