/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.privilege;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.ObjectReference;
import com.thoughtworks.proxy.kit.SimpleReference;
import com.thoughtworks.proxy.toys.delegate.DelegatingInvoker;
import com.thoughtworks.proxy.toys.delegate.DelegationMode;
import com.thoughtworks.proxy.toys.privilege.AccessControllerExecutor;
import com.thoughtworks.proxy.toys.privilege.ActionExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegingInvoker<T>
extends DelegatingInvoker<T> {
    private static final long serialVersionUID = 5352672950789740381L;
    private final ActionExecutor executor;

    public PrivilegingInvoker(ProxyFactory proxyFactory, ObjectReference<T> delegateReference, ActionExecutor executor) {
        super(proxyFactory, delegateReference, DelegationMode.DIRECT);
        this.executor = executor == null ? new AccessControllerExecutor() : executor;
    }

    public PrivilegingInvoker(T delegate, ActionExecutor executor) {
        this((ProxyFactory)new StandardProxyFactory(), new SimpleReference<T>(delegate), executor);
    }

    public PrivilegingInvoker(T delegate) {
        this(delegate, null);
    }

    @Override
    protected Object invokeOnDelegate(final Method method, final Object[] args) throws InvocationTargetException {
        try {
            return this.executor.execute(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return PrivilegingInvoker.super.invokeOnDelegate(method, args);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                throw (InvocationTargetException)InvocationTargetException.class.cast(cause);
            }
            throw new InvocationTargetException(cause);
        }
    }
}

