/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class CalluculateRestoreSizePerDeviceAndFolder {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUIDValue = config.getProperty("deviceUUID").toString();
        String folderValue = config.getProperty("folder").toString();
        boolean onlyLatestVersion = Boolean.parseBoolean(config.getProperty("onlyLatestVersion").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        FindIterable<Document> devices = null;
        devices = StringUtils.isEmpty(deviceUUIDValue) ? deviceColl.find() : deviceColl.find(new BasicDBObject("deviceUUID", deviceUUIDValue));
        for (Document device : devices) {
            MongoCollection<Document> bkpColl = db.getCollection(device.getString("destCollection"));
            String deviceUUID = device.getString("deviceUUID");
            ArrayList<Document> allFoldersList = new ArrayList<Document>();
            CalluculateRestoreSizePerDeviceAndFolder.getFolderListInRecursion(folderValue, bkpColl, deviceUUID, allFoldersList);
            System.out.println("Done total folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
            long fileSizes = 0L;
            for (Document folder : allFoldersList) {
                String folderName = "";
                folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", false));
                whereQuery.add(new BasicDBObject("present", true));
                whereQuery.add(new BasicDBObject("devicePath", folderName));
                andQuery.put("$and", whereQuery);
                FindIterable<Document> files = bkpColl.find(andQuery);
                ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                for (Document document : files) {
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString("devicePath"));
                    backUpImage.setFileName(document.getString("fileName"));
                    if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong("size"));
                    allFilesList.add(backUpImage);
                }
                List<BackUpImage> list = allFilesList;
                if (onlyLatestVersion) {
                    list = CalluculateRestoreSizePerDeviceAndFolder.getFilteredBackupImageList(allFilesList);
                }
                long folderSize = 0L;
                for (BackUpImage image : list) {
                    fileSizes += image.getSize();
                    folderSize += image.getSize();
                    System.out.println("@PVN@" + image.getDevicePath() + "/" + image.getFileName() + "|" + image.getSize());
                }
                System.out.println(String.valueOf(folderName) + " #$#$#$# " + list.size() + " #$#$#$# " + folderSize);
            }
            System.out.println(" #$#$#$# total Folder size:" + fileSizes);
        }
        client.close();
    }

    private static void getFolderListInRecursion(String folderValue, MongoCollection<Document> bkpColl, String deviceUUID, List<Document> allFoldersList) {
        FindIterable<Document> folders = CalluculateRestoreSizePerDeviceAndFolder.getFoldersList(bkpColl, deviceUUID, folderValue);
        folders.forEach(backUpImage -> {
            allFoldersList.add((Document)backUpImage);
            String devicePath = String.valueOf(backUpImage.getString("devicePath")) + "/" + backUpImage.getString("fileName");
            if (StringUtils.isEmpty(devicePath)) {
                devicePath = backUpImage.getString("fileName");
            }
            System.out.println("Inside loop to get immediate folders deevicePath:" + devicePath);
            CalluculateRestoreSizePerDeviceAndFolder.getFolderListInRecursion(devicePath, bkpColl, deviceUUID, allFoldersList);
        });
    }

    private static FindIterable<Document> getFoldersList(MongoCollection<Document> bkpColl, String deviceUUID, String devicePath) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("devicePath", devicePath));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        FindIterable<Document> folders = bkpColl.find(andQuery);
        return folders;
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

