/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DirectionalPoolListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<DirectionalPool>> {
    private final ImmutableSet.Builder<DirectionalPool> pools = ImmutableSet.builder();

    @Override
    public FluentIterable<DirectionalPool> getResult() {
        return FluentIterable.from(this.pools.build());
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "DirectionalPoolData")) {
            String tieBreak;
            Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
            DirectionalPool.Builder pool = DirectionalPool.builder().zoneId(attributes.get("Zoneid")).id(attributes.get("dirpoolid")).dname(attributes.get("Pooldname")).name(attributes.get("Description"));
            String type = attributes.get("DirPoolType");
            if (type != null) {
                pool.type(DirectionalPool.Type.valueOf(type));
            }
            if ((tieBreak = attributes.get("TieBreak")) != null) {
                pool.tieBreak(DirectionalPool.TieBreak.valueOf(tieBreak));
            }
            this.pools.add((Object)pool.build());
        }
    }
}

