/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class SoftwareDescription {
    private final int id;
    private final String longDescription;
    private final String manufacturer;
    private final String name;
    private final int operatingSystem;
    private final String referenceCode;
    private final String requiredUser;
    private final String version;
    private final int controlPanel;
    private final String upgradeSoftwareDescriptionId;
    private final String upgradeSwDescId;
    private final String virtualLicense;
    private final String virtualizationPlatform;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SoftwareDescription.builder().fromSoftwareDescription(this);
    }

    @ConstructorProperties(value={"id", "longDescription", "manufacturer", "name", "operatingSystem", "referenceCode", "requiredUser", "version", "controlPanel", "upgradeSoftwareDescriptionId", "upgradeSwDescId", "virtualLicense", "virtualizationPlatform"})
    protected SoftwareDescription(int id, @Nullable String longDescription, @Nullable String manufacturer, @Nullable String name, int operatingSystem, @Nullable String referenceCode, @Nullable String requiredUser, @Nullable String version, int controlPanel, @Nullable String upgradeSoftwareDescriptionId, @Nullable String upgradeSwDescId, @Nullable String virtualLicense, @Nullable String virtualizationPlatform) {
        this.id = id;
        this.longDescription = longDescription;
        this.manufacturer = manufacturer;
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.referenceCode = referenceCode;
        this.requiredUser = requiredUser;
        this.version = version;
        this.controlPanel = controlPanel;
        this.upgradeSoftwareDescriptionId = upgradeSoftwareDescriptionId;
        this.upgradeSwDescId = upgradeSwDescId;
        this.virtualLicense = virtualLicense;
        this.virtualizationPlatform = virtualizationPlatform;
    }

    public int getId() {
        return this.id;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getName() {
        return this.name;
    }

    public int getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getReferenceCode() {
        return this.referenceCode;
    }

    public String getRequiredUser() {
        return this.requiredUser;
    }

    public String getVersion() {
        return this.version;
    }

    public int getControlPanel() {
        return this.controlPanel;
    }

    public String getUpgradeSoftwareDescriptionId() {
        return this.upgradeSoftwareDescriptionId;
    }

    public String getUpgradeSwDescId() {
        return this.upgradeSwDescId;
    }

    public String getVirtualLicense() {
        return this.virtualLicense;
    }

    public String getVirtualizationPlatform() {
        return this.virtualizationPlatform;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftwareDescription that = (SoftwareDescription)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.longDescription, that.longDescription) && Objects.equal(this.manufacturer, that.manufacturer) && Objects.equal(this.name, that.name) && Objects.equal(this.operatingSystem, that.operatingSystem) && Objects.equal(this.referenceCode, that.referenceCode) && Objects.equal(this.requiredUser, that.requiredUser) && Objects.equal(this.version, that.version) && Objects.equal(this.controlPanel, that.controlPanel) && Objects.equal(this.upgradeSoftwareDescriptionId, that.upgradeSoftwareDescriptionId) && Objects.equal(this.upgradeSwDescId, that.upgradeSwDescId) && Objects.equal(this.virtualLicense, that.virtualLicense) && Objects.equal(this.virtualizationPlatform, that.virtualizationPlatform);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.longDescription, this.manufacturer, this.name, this.operatingSystem, this.referenceCode, this.requiredUser, this.version, this.controlPanel, this.upgradeSoftwareDescriptionId, this.upgradeSwDescId, this.virtualLicense, this.virtualizationPlatform);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("longDescription", this.longDescription).add("manufacturer", this.manufacturer).add("name", this.name).add("operatingSystem", this.operatingSystem).add("referenceCode", this.referenceCode).add("requiredUser", this.requiredUser).add("version", this.version).add("controlPanel", this.controlPanel).add("upgradeSoftwareDescriptionId", this.upgradeSoftwareDescriptionId).add("upgradeSwDescId", this.upgradeSwDescId).add("virtualLicense", this.virtualLicense).add("virtualizationPlatform", this.virtualizationPlatform).toString();
    }

    public static class Builder {
        protected int id;
        protected String longDescription;
        protected String manufacturer;
        protected String name;
        protected int operatingSystem;
        protected String referenceCode;
        protected String requiredUser;
        protected String version;
        protected int controlPanel;
        protected String upgradeSoftwareDescriptionId;
        protected String upgradeSwDescId;
        protected String virtualLicense;
        protected String virtualizationPlatform;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder operatingSystem(int operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder referenceCode(String referenceCode) {
            this.referenceCode = referenceCode;
            return this;
        }

        public Builder requiredUser(String requiredUser) {
            this.requiredUser = requiredUser;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder controlPanel(int controlPanel) {
            this.controlPanel = controlPanel;
            return this;
        }

        public Builder upgradeSoftwareDescriptionId(String upgradeSoftwareDescriptionId) {
            this.upgradeSoftwareDescriptionId = upgradeSoftwareDescriptionId;
            return this;
        }

        public Builder upgradeSwDescId(String upgradeSwDescId) {
            this.upgradeSwDescId = upgradeSwDescId;
            return this;
        }

        public Builder virtualLicense(String virtualLicense) {
            this.virtualLicense = virtualLicense;
            return this;
        }

        public Builder virtualizationPlatform(String virtualizationPlatform) {
            this.virtualizationPlatform = virtualizationPlatform;
            return this;
        }

        public SoftwareDescription build() {
            return new SoftwareDescription(this.id, this.longDescription, this.manufacturer, this.name, this.operatingSystem, this.referenceCode, this.requiredUser, this.version, this.controlPanel, this.upgradeSoftwareDescriptionId, this.upgradeSwDescId, this.virtualLicense, this.virtualizationPlatform);
        }

        public Builder fromSoftwareDescription(SoftwareDescription in) {
            return this.id(in.getId()).longDescription(in.getLongDescription()).manufacturer(in.getManufacturer()).name(in.getName()).operatingSystem(in.getOperatingSystem()).referenceCode(in.getReferenceCode()).requiredUser(in.getRequiredUser()).version(in.getVersion()).controlPanel(in.getControlPanel()).upgradeSoftwareDescriptionId(in.getUpgradeSoftwareDescriptionId()).upgradeSwDescId(in.getUpgradeSwDescId()).virtualLicense(in.getVirtualLicense()).virtualizationPlatform(in.getVirtualizationPlatform());
        }
    }
}

