/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.Payer;

@Singleton
public class BindPayerToXmlPayload
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        Preconditions.checkArgument(Preconditions.checkNotNull(toBind, "toBind") instanceof Payer, "this binder is only valid for Payer!");
        String text = String.format("<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>%s</Payer></RequestPaymentConfiguration>", ((Payer)((Object)toBind)).value());
        request.setPayload(text);
        request.getPayload().getContentMetadata().setContentType("text/xml");
        return request;
    }
}

