/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseNestedBoolean;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@RequestFilters(value={AuthenticateRequest.class})
public interface ConnectionApi {
    @Named(value="connectionthrottle:create")
    @PUT
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Path(value="/connectionthrottle")
    public void createOrUpdateConnectionThrottle(@WrapWith(value="connectionThrottle") ConnectionThrottle var1);

    @Named(value="connectionthrottle:get")
    @GET
    @Consumes(value={"application/json"})
    @SelectJson(value={"connectionThrottle"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/connectionthrottle")
    public ConnectionThrottle getConnectionThrottle();

    @Named(value="connectionthrottle:delete")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr422.class)
    @Path(value="/connectionthrottle")
    @Consumes(value={"*/*"})
    public boolean deleteConnectionThrottle();

    @Named(value="connectionlogging:state")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseNestedBoolean.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/connectionlogging")
    public boolean isConnectionLogging();

    @Named(value="connectionlogging:state")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Payload(value="{\"connectionLogging\":{\"enabled\":true}}")
    @Path(value="/connectionlogging")
    public void enableConnectionLogging();

    @Named(value="connectionlogging:state")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Payload(value="{\"connectionLogging\":{\"enabled\":false}}")
    @Path(value="/connectionlogging")
    public void disableConnectionLogging();
}

