/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.config;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.SSLModule;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.profitbricks.ProfitBricksApi;
import org.jclouds.profitbricks.domain.ServiceFault;
import org.jclouds.profitbricks.handlers.ProfitBricksHttpErrorHandler;
import org.jclouds.profitbricks.http.ResponseStatusFromPayloadHttpCommandExecutorService;
import org.jclouds.profitbricks.http.parser.ServiceFaultResponseHandler;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class ProfitBricksHttpApiModule
extends HttpApiModule<ProfitBricksApi> {
    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ProfitBricksHttpErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ProfitBricksHttpErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ProfitBricksHttpErrorHandler.class);
    }

    @ConfiguresHttpCommandExecutorService
    public static class ProfitBricksHttpCommandExecutorServiceModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.install(new SSLModule());
            this.bind(HttpCommandExecutorService.class).to(ResponseStatusFromPayloadHttpCommandExecutorService.class).in(Scopes.SINGLETON);
        }

        @Provides
        public ParseSax<ServiceFault> serviceFaultParser(ParseSax.Factory factory, Injector injector) {
            return factory.create(injector.getInstance(ServiceFaultResponseHandler.class));
        }
    }
}

