/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

public class ParsePasswordFromRootedInstance
implements Function<HttpResponse, String> {
    private final ParseJson<Map<String, Map<String, String>>> json;

    @Inject
    ParsePasswordFromRootedInstance(ParseJson<Map<String, Map<String, String>>> json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public String apply(HttpResponse from) {
        Map<String, Map<String, String>> result = this.json.apply(from);
        if (result.get("user") == null) {
            return null;
        }
        return result.get("user").get("password");
    }
}

