/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Subnet;
import org.jclouds.openstack.neutron.v2.features.SubnetApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class SubnetsToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Subnet, SubnetsToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected SubnetsToPagedIterable(NeutronApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<Subnet>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final SubnetApi subnetApi = this.api.getSubnetApi(region);
        return new Function<Object, IterableWithMarker<Subnet>>(){

            @Override
            public IterableWithMarker<Subnet> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast(subnetApi.list(paginationOptions));
            }

            public String toString() {
                return "listSubnets()";
            }
        };
    }
}

