/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.NetworkSegment;
import org.jclouds.openstack.neutron.v2.domain.NetworkStatus;
import org.jclouds.openstack.neutron.v2.domain.NetworkType;

public class Network {
    private String id;
    private NetworkStatus status;
    private ImmutableSet<String> subnets;
    private String name;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    private Boolean shared;
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="availability_zone")
    private String availabilityZone;
    @Named(value="provider:network_type")
    private NetworkType networkType;
    @Named(value="provider:physical_network")
    private String physicalNetworkName;
    @Named(value="provider:segmentation_id")
    private Integer segmentationId;
    @Named(value="router:external")
    private Boolean external;
    @Named(value="port_security_enabled")
    private Boolean portSecurity;
    @Named(value="n1kv:profile_id")
    private String profileId;
    @Named(value="n1kv:multicast_ip")
    private String multicastIp;
    @Named(value="n1kv:segment_add")
    private String segmentAdd;
    @Named(value="n1kv:segment_del")
    private String segmentDel;
    @Named(value="n1kv:member_segments")
    private String memberSegments;
    private ImmutableSet<NetworkSegment> segments;
    @Named(value="flavor:network")
    private String networkFlavor;

    @ConstructorProperties(value={"id", "status", "subnets", "name", "admin_state_up", "shared", "tenant_id", "availability_zone", "provider:network_type", "provider:physical_network", "provider:segmentation_id", "router:external", "port_security_enabled", "n1kv:profile_id", "n1kv:multicast_ip", "n1kv:segment_add", "n1kv:segment_del", "n1kv:member_segments", "segments", "flavor:network"})
    private Network(String id, NetworkStatus status, ImmutableSet<String> subnets, String name, Boolean adminStateUp, Boolean shared, String tenantId, String availabilityZone, NetworkType networkType, String physicalNetworkName, Integer segmentationId, Boolean external, Boolean portSecurity, String profileId, String multicastIp, String segmentAdd, String segmentDel, String memberSegments, ImmutableSet<NetworkSegment> segments, String networkFlavor) {
        this.id = id;
        this.status = status;
        this.subnets = subnets;
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.shared = shared;
        this.tenantId = tenantId;
        this.availabilityZone = availabilityZone;
        this.networkType = networkType;
        this.physicalNetworkName = physicalNetworkName;
        this.segmentationId = segmentationId;
        this.external = external;
        this.portSecurity = portSecurity;
        this.profileId = profileId;
        this.multicastIp = multicastIp;
        this.segmentAdd = segmentAdd;
        this.segmentDel = segmentDel;
        this.memberSegments = memberSegments;
        this.segments = segments;
        this.networkFlavor = networkFlavor;
    }

    private Network() {
    }

    private Network(Network network) {
        this(network.id, network.status, network.subnets, network.name, network.adminStateUp, network.shared, network.tenantId, network.availabilityZone, network.networkType, network.physicalNetworkName, network.segmentationId, network.external, network.portSecurity, network.profileId, network.multicastIp, network.segmentAdd, network.segmentDel, network.memberSegments, network.segments, network.networkFlavor);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public NetworkStatus getStatus() {
        return this.status;
    }

    @Nullable
    public ImmutableSet<String> getSubnets() {
        return this.subnets;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public Boolean getShared() {
        return this.shared;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Nullable
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Nullable
    public String getPhysicalNetworkName() {
        return this.physicalNetworkName;
    }

    @Nullable
    public Integer getSegmentationId() {
        return this.segmentationId;
    }

    @Nullable
    public Boolean getExternal() {
        return this.external;
    }

    @Nullable
    public Boolean getPortSecurity() {
        return this.portSecurity;
    }

    @Nullable
    public String getProfileId() {
        return this.profileId;
    }

    @Nullable
    public String getMulticastIp() {
        return this.multicastIp;
    }

    @Nullable
    public String getSegmentAdd() {
        return this.segmentAdd;
    }

    @Nullable
    public String getSegmentDel() {
        return this.segmentDel;
    }

    @Nullable
    public String getMemberSegments() {
        return this.memberSegments;
    }

    @Nullable
    public ImmutableSet<NetworkSegment> getSegments() {
        return this.segments;
    }

    @Nullable
    public String getNetworkFlavor() {
        return this.networkFlavor;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.status, this.subnets, this.name, this.adminStateUp, this.shared, this.tenantId, this.availabilityZone, this.networkType, this.physicalNetworkName, this.segmentationId, this.external, this.portSecurity, this.profileId, this.multicastIp, this.segmentAdd, this.segmentDel, this.memberSegments, this.segments, this.networkFlavor});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Network that = (Network)Network.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal(this.subnets, that.subnets) && Objects.equal(this.name, that.name) && Objects.equal(this.adminStateUp, that.adminStateUp) && Objects.equal(this.shared, that.shared) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.availabilityZone, that.availabilityZone) && Objects.equal((Object)this.networkType, (Object)that.networkType) && Objects.equal(this.physicalNetworkName, that.physicalNetworkName) && Objects.equal(this.segmentationId, that.segmentationId) && Objects.equal(this.external, that.external) && Objects.equal(this.portSecurity, that.portSecurity) && Objects.equal(this.profileId, that.profileId) && Objects.equal(this.multicastIp, that.multicastIp) && Objects.equal(this.segmentAdd, that.segmentAdd) && Objects.equal(this.segmentDel, that.segmentDel) && Objects.equal(this.memberSegments, that.memberSegments) && Objects.equal(this.segments, that.segments) && Objects.equal(this.networkFlavor, that.networkFlavor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("status", (Object)this.status).add("subnets", this.subnets).add("name", this.name).add("adminStateUp", this.adminStateUp).add("shared", this.shared).add("tenantId", this.tenantId).add("availabilityZone", this.availabilityZone).add("networkType", (Object)this.networkType).add("physicalNetworkName", this.physicalNetworkName).add("segmentationId", this.segmentationId).add("external", this.external).add("portSecurity", this.portSecurity).add("profileId", this.profileId).add("multicastIp", this.multicastIp).add("segmentAdd", this.segmentAdd).add("segmentDel", this.segmentDel).add("memberSegments", this.memberSegments).add("segments", this.segments).add("networkFlavor", this.networkFlavor).toString();
    }

    public static CreateBuilder createBuilder(String name) {
        return new CreateBuilder(name);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdateNetwork
    extends Network {
        private UpdateNetwork(Network network) {
            super(network);
        }
    }

    public static class CreateNetwork
    extends Network {
        private CreateNetwork(Network network) {
            super(network);
            Preconditions.checkNotNull(network.name, "name should not be null");
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateNetwork build() {
            return new UpdateNetwork(this.network);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String name) {
            this.network.name = name;
        }

        public CreateNetwork build() {
            return new CreateNetwork(this.network);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Network network = new Network();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.network.name = name;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.network.adminStateUp = adminStateUp;
            return this.self();
        }

        public ParameterizedBuilderType shared(Boolean shared) {
            this.network.shared = shared;
            return this.self();
        }

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.network.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType availabilityZone(String availabilityZone) {
            this.network.availabilityZone = availabilityZone;
            return this.self();
        }

        public ParameterizedBuilderType networkType(NetworkType networkType) {
            this.network.networkType = networkType;
            return this.self();
        }

        public ParameterizedBuilderType physicalNetworkName(String physicalNetworkName) {
            this.network.physicalNetworkName = physicalNetworkName;
            return this.self();
        }

        public ParameterizedBuilderType segmentationId(Integer segmentationId) {
            this.network.segmentationId = segmentationId;
            return this.self();
        }

        public ParameterizedBuilderType external(Boolean external) {
            this.network.external = external;
            return this.self();
        }

        public ParameterizedBuilderType portSecurity(Boolean portSecurity) {
            this.network.portSecurity = portSecurity;
            return this.self();
        }

        public ParameterizedBuilderType profileId(String profileId) {
            this.network.profileId = profileId;
            return this.self();
        }

        public ParameterizedBuilderType multicastIp(String multicastIp) {
            this.network.multicastIp = multicastIp;
            return this.self();
        }

        public ParameterizedBuilderType segmentAdd(String segmentAdd) {
            this.network.segmentAdd = segmentAdd;
            return this.self();
        }

        public ParameterizedBuilderType segmentDel(String segmentDel) {
            this.network.segmentDel = segmentDel;
            return this.self();
        }

        public ParameterizedBuilderType memberSegments(String memberSegments) {
            this.network.memberSegments = memberSegments;
            return this.self();
        }

        public ParameterizedBuilderType segments(ImmutableSet<NetworkSegment> segments) {
            this.network.segments = segments;
            return this.self();
        }

        public ParameterizedBuilderType networkFlavor(String networkFlavor) {
            this.network.networkFlavor = networkFlavor;
            return this.self();
        }
    }
}

