/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.UserApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseUsers
extends ParseJson<Users> {
    @Inject
    public ParseUsers(Json json) {
        super(json, TypeLiteral.get(Users.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<User, ToPagedIterable> {
        private final KeystoneApi api;

        @Inject
        protected ToPagedIterable(KeystoneApi api) {
            this.api = Preconditions.checkNotNull(api, "api");
        }

        @Override
        protected Function<Object, IterableWithMarker<User>> markerToNextForArg0(Optional<Object> ignored2) {
            final UserApi userApi = this.api.getUserApi().get();
            return new Function<Object, IterableWithMarker<User>>(){

                @Override
                public IterableWithMarker<User> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(userApi.list(paginationOptions));
                }

                public String toString() {
                    return "listUsers()";
                }
            };
        }
    }

    static class Users
    extends PaginatedCollection<User> {
        @ConstructorProperties(value={"users", "users_links"})
        protected Users(Iterable<User> users, Iterable<Link> users_links) {
            super(users, users_links);
        }
    }
}

