/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Collections;
import java.util.Map;
import org.jclouds.io.payloads.BasePayload;
import org.jclouds.io.payloads.Part;

public class MultipartForm
extends BasePayload<Iterable<? extends Part>> {
    public static final String BOUNDARY = "--JCLOUDS--";
    private static final String rn = "\r\n";
    private static final String dd = "--";
    private final String boundary;
    private final Iterable<? extends Part> content;
    private final boolean isRepeatable;

    public MultipartForm(String boundary, Iterable<? extends Part> content) {
        super(content);
        this.boundary = boundary;
        this.content = content;
        this.getContentMetadata().setContentType("multipart/form-data; boundary=" + boundary);
        String boundaryrn = boundary + rn;
        boolean isRepeatable = true;
        long contentLength = 0L;
        for (Part part : content) {
            if (!part.isRepeatable()) {
                isRepeatable = false;
            }
            contentLength += part.getContentMetadata().getContentLength() + (long)this.createHeaders(boundaryrn, part).length() + (long)this.createRn().length();
        }
        this.getContentMetadata().setContentLength(contentLength += (long)MultipartForm.createFooter(boundary).length());
        this.isRepeatable = isRepeatable;
    }

    public MultipartForm(String boundary, Part ... parts) {
        this(boundary, Lists.newArrayList(parts));
    }

    public MultipartForm(Part ... parts) {
        this(BOUNDARY, parts);
    }

    private String createRn() {
        return rn;
    }

    private String createHeaders(String boundaryrn, Part part) {
        StringBuilder builder = new StringBuilder(dd).append(boundaryrn);
        for (Map.Entry<String, String> entry : part.getHeaders().entries()) {
            String header = String.format("%s: %s%s", entry.getKey(), entry.getValue(), rn);
            builder.append(header);
        }
        builder.append(rn);
        return builder.toString();
    }

    private static String createFooter(String boundary) {
        return dd + boundary + dd + rn;
    }

    @Override
    public InputStream openStream() throws IOException {
        String boundaryrn = this.boundary + rn;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Part part : this.content) {
            ((ImmutableList.Builder)((ImmutableList.Builder)builder.add(new ByteArrayInputStream(this.createHeaders(boundaryrn, part).getBytes()))).add(part.openStream())).add(new ByteArrayInputStream(this.createRn().getBytes()));
        }
        builder.add(new ByteArrayInputStream(MultipartForm.createFooter(this.boundary).getBytes()));
        return new SequenceInputStream(Collections.enumeration(builder.build()));
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Override
    public void release() {
        for (Part part : this.content) {
            part.release();
        }
    }
}

