/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.dynect.v3.DynECTExceptions;
import org.jclouds.dynect.v3.domain.GeoRegionGroup;
import org.jclouds.dynect.v3.filters.AlwaysAddContentType;
import org.jclouds.dynect.v3.filters.SessionManager;
import org.jclouds.dynect.v3.functions.ExtractLastPathComponent;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Headers(keys={"API-Version"}, values={"{jclouds.api-version}"})
@Path(value="/GeoRegionGroup/{serviceName}")
@RequestFilters(value={AlwaysAddContentType.class, SessionManager.class})
public interface GeoRegionGroupApi {
    @Named(value="ListGeoRegionGroupNames")
    @GET
    @SelectJson(value={"data"})
    @Transform(value=ExtractLastPathComponent.class)
    public FluentIterable<String> list() throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetGeoRegionGroup")
    @GET
    @Path(value="/{groupName}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public GeoRegionGroup get(@PathParam(value="groupName") String var1) throws DynECTExceptions.JobStillRunningException;
}

